/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.engines;

import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.engines.RSACoreEngine;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            if (k.getPublicExponent() != null) {
                BigInteger input = this.core.convertInput(in, inOff, inLen);
                BigInteger m = k.getModulus();
                BigInteger r = this.calculateR(m);
                BigInteger result = this.core.processBlock(r.modPow(k.getPublicExponent(), m).multiply(input).mod(m));
                return this.core.convertOutput(result.multiply(r.modInverse(m)).mod(m));
            }
            return this.core.convertOutput(this.core.processBlock(this.core.convertInput(in, inOff, inLen)));
        }
        return this.core.convertOutput(this.core.processBlock(this.core.convertInput(in, inOff, inLen)));
    }

    private BigInteger calculateR(BigInteger m) {
        int max = m.bitLength() - 1;
        int min = max / 2;
        int length = (this.random.nextInt() & 0xFF) * ((max - min) / 255) + min;
        BigInteger factor = new BigInteger(length, this.random);
        while (factor.equals(ZERO)) {
            factor = new BigInteger(length, this.random);
        }
        return factor;
    }
}

