/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.digests;

import cn.com.infosec.crypto.digests.GeneralDigest;
import cn.com.infosec.crypto.digests.SHA256Digest;
import cn.com.infosec.crypto.digests.SM3Digest;

public class SHA256SM3Digest
extends GeneralDigest {
    private static final int DIGESTLENGTH = 64;
    private SHA256Digest sha256 = new SHA256Digest();
    private SM3Digest sm3 = new SM3Digest();

    public SHA256SM3Digest() {
        this.sha256.reset();
        this.sm3.reset();
    }

    public SHA256SM3Digest(SHA256SM3Digest t) {
        this.sha256 = new SHA256Digest(t.sha256);
        this.sm3 = new SM3Digest(t.sm3);
    }

    public String getAlgorithmName() {
        return "SHA256SM3";
    }

    public int getDigestSize() {
        return 64;
    }

    public final void update(byte[] b, int off, int len) {
        this.sha256.update(b, off, len);
        this.sm3.update(b, off, len);
    }

    public final void update(byte b) {
        this.sha256.update(b);
        this.sm3.update(b);
    }

    public int doFinal(byte[] out, int outOff) {
        this.sha256.doFinal(out, outOff);
        this.sm3.doFinal(out, outOff + 32);
        return 64;
    }

    protected void processWord(byte[] in, int inOff) {
    }

    protected void processLength(long bitLength) {
    }

    protected void processBlock() {
    }
}

