/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERPrintableString;
import cn.com.infosec.util.Strings;
import java.io.IOException;

public abstract class X509NameEntryConverter {
    protected DERObject convertHexEncoded(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        int index = 0;
        while (index != data.length) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
            } else {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
            }
            ++index;
        }
        ASN1InputStream aIn = new ASN1InputStream(data);
        return aIn.readObject();
    }

    protected boolean canBePrintable(String str) {
        return DERPrintableString.isPrintableString(str);
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);
}

