/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.isismtt.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERPrintableString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.x500.DirectoryString;
import cn.com.infosec.asn1.x509.GeneralName;
import cn.com.infosec.asn1.x509.IssuerSerial;
import java.util.Enumeration;

public class ProcurationSyntax
extends ASN1Encodable {
    private String country;
    private DirectoryString typeOfSubstitution;
    private GeneralName thirdPerson;
    private IssuerSerial certRef;

    public static ProcurationSyntax getInstance(Object obj) {
        if (obj == null || obj instanceof ProcurationSyntax) {
            return (ProcurationSyntax)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ProcurationSyntax((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private ProcurationSyntax(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject o = ASN1TaggedObject.getInstance(e.nextElement());
            switch (o.getTagNo()) {
                case 1: {
                    this.country = DERPrintableString.getInstance(o, true).getString();
                    break;
                }
                case 2: {
                    this.typeOfSubstitution = DirectoryString.getInstance(o, true);
                    break;
                }
                case 3: {
                    DERObject signingFor = o.getObject();
                    if (signingFor instanceof ASN1TaggedObject) {
                        this.thirdPerson = GeneralName.getInstance(signingFor);
                        break;
                    }
                    this.certRef = IssuerSerial.getInstance(signingFor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag number: " + o.getTagNo());
                }
            }
        }
    }

    public ProcurationSyntax(String country, DirectoryString typeOfSubstitution, IssuerSerial certRef) {
        this.country = country;
        this.typeOfSubstitution = typeOfSubstitution;
        this.thirdPerson = null;
        this.certRef = certRef;
    }

    public ProcurationSyntax(String country, DirectoryString typeOfSubstitution, GeneralName thirdPerson) {
        this.country = country;
        this.typeOfSubstitution = typeOfSubstitution;
        this.thirdPerson = thirdPerson;
        this.certRef = null;
    }

    public String getCountry() {
        return this.country;
    }

    public DirectoryString getTypeOfSubstitution() {
        return this.typeOfSubstitution;
    }

    public GeneralName getThirdPerson() {
        return this.thirdPerson;
    }

    public IssuerSerial getCertRef() {
        return this.certRef;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (this.country != null) {
            vec.add(new DERTaggedObject(true, 1, new DERPrintableString(this.country, true)));
        }
        if (this.typeOfSubstitution != null) {
            vec.add(new DERTaggedObject(true, 2, this.typeOfSubstitution));
        }
        if (this.thirdPerson != null) {
            vec.add(new DERTaggedObject(true, 3, this.thirdPerson));
        } else {
            vec.add(new DERTaggedObject(true, 3, this.certRef));
        }
        return new DERSequence(vec);
    }
}

