/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.ess;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERUTF8String;

public class ContentHints
extends ASN1Encodable {
    private DERUTF8String contentDescription;
    private DERObjectIdentifier contentType;

    public static ContentHints getInstance(Object o) {
        if (o == null || o instanceof ContentHints) {
            return (ContentHints)o;
        }
        if (o instanceof ASN1Sequence) {
            return new ContentHints((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in 'ContentHints' factory : " + o.getClass().getName() + ".");
    }

    private ContentHints(ASN1Sequence seq) {
        DEREncodable field = seq.getObjectAt(0);
        if (field.getDERObject() instanceof DERUTF8String) {
            this.contentDescription = DERUTF8String.getInstance(field);
            this.contentType = DERObjectIdentifier.getInstance(seq.getObjectAt(1));
        } else {
            this.contentType = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
        }
    }

    public ContentHints(DERObjectIdentifier contentType) {
        this.contentType = contentType;
        this.contentDescription = null;
    }

    public ContentHints(DERObjectIdentifier contentType, DERUTF8String contentDescription) {
        this.contentType = contentType;
        this.contentDescription = contentDescription;
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DERUTF8String getContentDescription() {
        return this.contentDescription;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.contentDescription != null) {
            v.add(this.contentDescription);
        }
        v.add(this.contentType);
        return new DERSequence(v);
    }
}

