/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca.encryption;

import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.oscca.encryption.SM4;

public class SM4CBC
extends SM4 {
    private int mod = 0;
    public static int ENC_MOD = 1;
    public static int DEC_MOD = 2;
    private byte[] key;
    private int[] rkey;
    private byte[] iv;
    byte[] tr;
    private byte[] remainData = new byte[0];

    public SM4CBC(int mod) {
        this.mod = mod;
    }

    public void init(byte[] key, byte[] iv) throws CryptoException {
        if (key.length < 16) {
            throw new CryptoException("Invalid SM4 key length:" + key.length + " must be 16");
        }
        if (iv.length < 16) {
            throw new CryptoException("Invalid iv length:" + key.length + " must be 16");
        }
        this.key = new byte[16];
        System.arraycopy(key, 0, this.key, 0, 16);
        this.iv = new byte[16];
        System.arraycopy(iv, 0, this.iv, 0, 16);
        this.rkey = new int[32];
        SM4CBC.sm4_key_exp(key, this.rkey);
        this.tr = new byte[16];
        this.remainData = new byte[0];
    }

    public byte[] update(byte[] in, int offset, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(in, offset, tmp, 0, length);
        return this.update(tmp);
    }

    public byte[] update(byte[] in) {
        if (this.mod == ENC_MOD) {
            return this.encryptUpdate(in);
        }
        return this.decryptUpdate(in);
    }

    private byte[] decryptFinal() throws CryptoException {
        if (this.remainData.length % 16 != 0) {
            throw new CryptoException("decrypt failed");
        }
        int in_len_bytes = this.remainData.length;
        int numBlocks = in_len_bytes / 16;
        byte[] out = new byte[numBlocks * 16];
        int i = 0;
        while (i < numBlocks) {
            System.arraycopy(this.remainData, i * 16, this.tr, 0, 16);
            byte[] ivTmp = new byte[16];
            System.arraycopy(this.tr, 0, ivTmp, 0, 16);
            SM4CBC.sm4_decrypt_rk(this.tr, this.rkey, this.tr);
            int j = 0;
            while (j < 16) {
                out[j + i * 16] = (byte)(this.tr[j] ^ this.iv[j]);
                ++j;
            }
            this.iv = ivTmp;
            ++i;
        }
        byte[] rt = new byte[out.length - out[out.length - 1]];
        System.arraycopy(out, 0, rt, 0, rt.length);
        return rt;
    }

    private byte[] decryptUpdate(byte[] in) {
        int in_len_bytes = this.remainData.length + in.length;
        int numBlocks = in_len_bytes / 16;
        numBlocks = numBlocks > 0 ? numBlocks - 1 : 0;
        int remainLength = in_len_bytes - numBlocks * 16;
        byte[] out = new byte[numBlocks * 16];
        int i = 0;
        while (i < numBlocks) {
            if (i == 0) {
                if (this.remainData.length > 16) {
                    System.arraycopy(this.remainData, 0, this.tr, 0, 16);
                } else {
                    System.arraycopy(this.remainData, 0, this.tr, 0, this.remainData.length);
                    System.arraycopy(in, 0, this.tr, this.remainData.length, 16 - this.remainData.length);
                }
            } else if (i == 1) {
                if (this.remainData.length > 16) {
                    System.arraycopy(this.remainData, 16, this.tr, 0, this.remainData.length - 16);
                    System.arraycopy(in, 0, this.tr, this.remainData.length - 16, 32 - this.remainData.length);
                } else {
                    System.arraycopy(in, i * 16 - this.remainData.length, this.tr, 0, 16);
                }
            } else {
                System.arraycopy(in, i * 16 - this.remainData.length, this.tr, 0, 16);
            }
            byte[] ivTmp = new byte[16];
            System.arraycopy(this.tr, 0, ivTmp, 0, 16);
            SM4CBC.sm4_decrypt_rk(this.tr, this.rkey, this.tr);
            int j = 0;
            while (j < 16) {
                out[j + i * 16] = (byte)(this.tr[j] ^ this.iv[j]);
                ++j;
            }
            this.iv = ivTmp;
            ++i;
        }
        this.remainData = new byte[remainLength];
        System.arraycopy(in, in.length - remainLength, this.remainData, 0, remainLength);
        return out;
    }

    private byte[] encryptUpdate(byte[] in) {
        int in_len_bytes = this.remainData.length + in.length;
        int numBlocks = in_len_bytes / 16;
        int remainLength = in_len_bytes % 16;
        byte[] out = new byte[numBlocks * 16];
        int i = 0;
        while (i < numBlocks) {
            if (i == 0) {
                System.arraycopy(this.remainData, 0, this.tr, 0, this.remainData.length);
                System.arraycopy(in, 0, this.tr, this.remainData.length, 16 - this.remainData.length);
            } else {
                System.arraycopy(in, i * 16 - this.remainData.length, this.tr, 0, 16);
            }
            int j = 0;
            while (j < 16) {
                this.tr[j] = (byte)(this.tr[j] ^ this.iv[j]);
                ++j;
            }
            SM4CBC.sm4_encrypt_rk(this.tr, this.rkey, this.tr);
            j = 0;
            while (j < 16) {
                out[j + i * 16] = this.tr[j];
                this.iv[j] = this.tr[j];
                ++j;
            }
            ++i;
        }
        this.remainData = new byte[remainLength];
        System.arraycopy(in, in.length - remainLength, this.remainData, 0, remainLength);
        return out;
    }

    public byte[] doFinal() throws CryptoException {
        if (this.mod == ENC_MOD) {
            return this.encryptFinal();
        }
        return this.decryptFinal();
    }

    private byte[] encryptFinal() {
        int l = 16 - this.remainData.length;
        System.arraycopy(this.remainData, 0, this.tr, 0, this.remainData.length);
        int i = this.remainData.length;
        while (i < 16) {
            this.tr[i] = (byte)l;
            ++i;
        }
        byte[] out = new byte[16];
        int i2 = 0;
        while (i2 < 16) {
            int n = i2;
            this.tr[n] = (byte)(this.tr[n] ^ this.iv[i2]);
            ++i2;
        }
        SM4CBC.sm4_encrypt_rk(this.tr, this.rkey, out);
        return out;
    }
}

