/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca;

import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.oscca.sm2.SM2Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class OSCCAMessageDigest {
    private static byte[] abGxGy;

    static {
        byte[] a = SM2Util.gma.toByteArray();
        byte[] tmp = new byte[32];
        System.arraycopy(a, 1, tmp, 0, 32);
        a = tmp;
        byte[] b = SM2Util.gmb.toByteArray();
        byte[] Gx = SM2Util.gmgx.toByteArray();
        byte[] Gy = SM2Util.gmgy.toByteArray();
        tmp = new byte[32];
        System.arraycopy(Gy, 1, tmp, 0, 32);
        Gy = tmp;
        abGxGy = new byte[a.length + b.length + Gx.length + Gy.length];
        int start = 0;
        System.arraycopy(a, 0, abGxGy, start, a.length);
        System.arraycopy(b, 0, abGxGy, start += a.length, b.length);
        System.arraycopy(Gx, 0, abGxGy, start += b.length, Gx.length);
        System.arraycopy(Gy, 0, abGxGy, start += Gx.length, Gy.length);
    }

    public static byte[] SM3Digest(byte[] puid, byte[] x, byte[] y, byte[] msg) {
        if (puid == null) {
            return SM3.SM3Digest(msg);
        }
        byte[] tmp = OSCCAMessageDigest.connect(puid, x, y);
        byte[] Z = SM3.SM3Digest(tmp);
        tmp = OSCCAMessageDigest.connect(Z, msg);
        return SM3.SM3Digest(tmp);
    }

    public static byte[] SM3Digest(byte[] Z, InputStream msg) throws IOException {
        SM3 dig = new SM3();
        dig.update(Z);
        byte[] bs = new byte[102400];
        int readed = 0;
        while ((readed = msg.read(bs)) > 0) {
            dig.update(bs, 0, readed);
        }
        byte[] result = new byte[dig.getDigestLength()];
        dig.digest(result);
        return result;
    }

    public static byte[] computeZ(String alg, byte[] puid, byte[] x, byte[] y) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (puid == null) {
            return new byte[0];
        }
        byte[] tmp = OSCCAMessageDigest.connect(puid, x, y);
        if (alg.startsWith("SM")) {
            return SM3.SM3Digest(tmp);
        }
        MessageDigest md = MessageDigest.getInstance(alg, "INFOSEC");
        if (!alg.endsWith("256")) {
            MessageDigest md256 = MessageDigest.getInstance("SHA256", "INFOSEC");
            return md256.digest(tmp);
        }
        return md.digest(tmp);
    }

    public static byte[] SHADigest(String alg, byte[] puid, byte[] x, byte[] y, byte[] msg) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = MessageDigest.getInstance(alg, "INFOSEC");
        if (puid == null) {
            return md.digest(msg);
        }
        byte[] Z = null;
        byte[] tmp = OSCCAMessageDigest.connect(puid, x, y);
        if (!alg.endsWith("256")) {
            MessageDigest md256 = MessageDigest.getInstance("SHA256", "INFOSEC");
            Z = md256.digest(tmp);
        } else {
            Z = md.digest(tmp);
        }
        tmp = OSCCAMessageDigest.connect(Z, msg);
        return md.digest(tmp);
    }

    public static byte[] SHADigest(byte[] Z, InputStream msg, String alg) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest dig = MessageDigest.getInstance(alg, "INFOSEC");
        dig.update(Z);
        byte[] bs = new byte[102400];
        int readed = 0;
        while ((readed = msg.read(bs)) > 0) {
            dig.update(bs, 0, readed);
        }
        return dig.digest();
    }

    private static byte[] connect(byte[] Z, byte[] M) {
        byte[] tmp = new byte[Z.length + M.length];
        System.arraycopy(Z, 0, tmp, 0, Z.length);
        System.arraycopy(M, 0, tmp, Z.length, M.length);
        return tmp;
    }

    private static byte[] connect(byte[] puid, byte[] x, byte[] y) {
        byte[] tmp = new byte[2 + puid.length + abGxGy.length + x.length + y.length];
        int entlen = puid.length * 8;
        byte[] entlenBs = new byte[]{(byte)(0xFF & entlen >> 8), (byte)(0xFF & entlen)};
        int start = 0;
        System.arraycopy(entlenBs, 0, tmp, start, 2);
        System.arraycopy(puid, 0, tmp, start += 2, puid.length);
        System.arraycopy(abGxGy, 0, tmp, start += puid.length, abGxGy.length);
        System.arraycopy(x, 0, tmp, start += abGxGy.length, x.length);
        System.arraycopy(y, 0, tmp, start += x.length, y.length);
        return tmp;
    }
}

