/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.DERObjectGenerater;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class PKCS7SignedDataGenerater
extends DERObjectGenerater {
    private PKCS7SignedData paras;
    private byte[] version = new byte[]{2, 1, 1};
    private byte[] digestAlgorithms;
    private byte[] contentInfo;
    private byte[] certificates;
    private byte[] issuerAndSerialNumber;
    private byte[] digestAlgorithm;
    private byte[] digestEncryptionAlgorithm;
    private byte[] encryptDigest;

    public PKCS7SignedDataGenerater(PKCS7SignedData paras) {
        this.paras = paras;
    }

    public byte[] generatePKCS7SignedData() throws CertificateEncodingException, IOException {
        byte[] content = new byte[]{};
        content = DERUtil.connect(content, this.version);
        if (this.digestAlgorithm == null) {
            this.digestAlgorithm = this.generateAlgorithmIdentifier(this.paras.getDigestAlgOid());
        }
        if (this.digestAlgorithms == null) {
            this.digestAlgorithms = DERUtil.generateDERCode(49, this.digestAlgorithm);
        }
        content = DERUtil.connect(content, this.digestAlgorithms);
        if (this.contentInfo == null) {
            byte[] tmpoid;
            this.contentInfo = this.paras.getSignedDataOID() != null ? ((tmpoid = this.paras.getSignedDataOID())[0] != 6 ? DERUtil.generateDERCode(6, tmpoid) : tmpoid) : OID_PKCS7_SIGNEDDATA;
            if (this.paras.getContent() == null) {
                this.paras.setContent(new byte[0]);
            }
            byte[] plainText = this.paras.getContent();
            plainText = DERUtil.generateDERCode(4, plainText);
            plainText = DERUtil.generateDERCode(160, plainText);
            this.contentInfo = DERUtil.connect(this.contentInfo, plainText);
            this.contentInfo = DERUtil.generateDERCode(48, this.contentInfo);
        }
        content = DERUtil.connect(content, this.contentInfo);
        if (this.certificates != null) {
            content = DERUtil.connect(content, this.certificates);
        } else if (this.paras.getCerts() != null && this.paras.getCerts().length > 0) {
            this.certificates = new byte[0];
            Certificate[] certs = this.paras.getCerts();
            int i = 0;
            while (i < certs.length) {
                this.certificates = DERUtil.connect(this.certificates, certs[i].getEncoded());
                ++i;
            }
            this.certificates = DERUtil.generateDERCode(160, this.certificates);
            content = DERUtil.connect(content, this.certificates);
        }
        byte[] signerInfo = this.generateSignerInfo();
        content = DERUtil.connect(content, signerInfo);
        content = DERUtil.generateDERCode(48, content);
        content = DERUtil.generateDERCode(160, content);
        content = DERUtil.connect(OID_PKCS7_SIGNEDDATA, content);
        content = DERUtil.generateDERCode(48, content);
        return content;
    }

    private byte[] generateSignerInfo() throws IOException {
        byte[] signerInfo = new byte[]{};
        signerInfo = DERUtil.connect(signerInfo, this.version);
        if (this.issuerAndSerialNumber == null) {
            this.issuerAndSerialNumber = this.paras.getSignCertIssuerSubjectDer() == null ? this.generateDN(this.paras.getSignCertIssuerSubject()) : this.paras.getSignCertIssuerSubjectDer();
            byte[] serialNum = this.paras.getSignCertSN().toByteArray();
            serialNum = DERUtil.generateDERCode(2, serialNum);
            this.issuerAndSerialNumber = DERUtil.connect(this.issuerAndSerialNumber, serialNum);
            this.issuerAndSerialNumber = DERUtil.generateDERCode(48, this.issuerAndSerialNumber);
        }
        signerInfo = DERUtil.connect(signerInfo, this.issuerAndSerialNumber);
        signerInfo = DERUtil.connect(signerInfo, this.digestAlgorithm);
        this.digestEncryptionAlgorithm = this.generateAlgorithmIdentifier(this.paras.getDigestEncryptionAlgOid());
        signerInfo = DERUtil.connect(signerInfo, this.digestEncryptionAlgorithm);
        this.encryptDigest = DERUtil.generateDERCode(4, this.paras.getSignature());
        signerInfo = DERUtil.connect(signerInfo, this.encryptDigest);
        signerInfo = DERUtil.generateDERCode(48, signerInfo);
        signerInfo = DERUtil.generateDERCode(49, signerInfo);
        return signerInfo;
    }

    public PKCS7SignedData getParas() {
        return this.paras;
    }

    public void setParas(PKCS7SignedData paras) {
        this.paras = paras;
        this.digestAlgorithms = null;
        this.contentInfo = null;
        this.certificates = null;
        this.issuerAndSerialNumber = null;
        this.digestAlgorithm = null;
        this.digestEncryptionAlgorithm = null;
        this.encryptDigest = null;
    }

    public byte[] getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public void setDigestAlgorithms(byte[] digestAlgorithms) {
        this.digestAlgorithms = digestAlgorithms;
    }

    public byte[] getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(byte[] contentInfo) {
        this.contentInfo = contentInfo;
    }

    public byte[] getCertificates() {
        return this.certificates;
    }

    public void setCertificates(byte[] certificates) {
        this.certificates = certificates;
    }

    public byte[] getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public void setIssuerAndSerialNumber(byte[] issuerAndSerialNumber) {
        this.issuerAndSerialNumber = issuerAndSerialNumber;
    }

    public byte[] getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(byte[] digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public byte[] getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public void setDigestEncryptionAlgorithm(byte[] digestEncryptionAlgorithm) {
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
    }

    public byte[] getEncryptDigest() {
        return this.encryptDigest;
    }

    public void setEncryptDigest(byte[] encryptDigest) {
        this.encryptDigest = encryptDigest;
    }

    public byte[] getVersion() {
        return this.version;
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }
}

