/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class TestHashSign {
    public static void main(String[] args) throws Exception {
        NetSignAgent.initialize("D:\\WORK\\myjava\\infosec\\netsign\\PBC2_COM_NetSign\\netsignagent.properties");
        TestHashSign.testRAW();
    }

    private static void testDetach() throws Exception {
        NetSignResult res = NetSignAgent.detachedSignature(new FileInputStream("d:/TEMP/1.txt"), "C=cn,O=INFOSEC,CN=CNAPS SM2 Test", "SM3");
        System.out.println(res.getStringResult("Base64_Signed_Text"));
        res = NetSignAgent.detachedVerify(new FileInputStream("d:/TEMP/1.txt"), res.getStringResult("Base64_Signed_Text"), true);
        System.out.println(res.getStringResult("Sign_Subject"));
        System.out.println(res.getStringResult("Sign_Ser_Number"));
        System.out.println(res.getStringResult("Sign_Issuer_Subject"));
        System.out.println(res.getStringResult("Sign_Start_Time"));
        System.out.println(res.getStringResult("Sign_End_Time"));
        System.out.println(res.getSignCert().toString());
    }

    private static void testRAW() throws Exception {
        String certStr = "MIIDAzCCAeugAwIBAgIES5IBODANBgkqhkiG9w0BAQUFADA2MQswCQYDVQQGEwJjbjESMBAGA1UEChMJc3luMDgwOTI0MRMwEQYDVQQDEwpyb290MDgwOTI0MB4XDTA4MTEwNzA4NDMyMVoXDTE3MTEwNzA4NDMyMVowMTEOMAwGA1UEAwwFNXllYXIxEjAQBgNVBAoMCXN5bjA4MDkyNDELMAkGA1UEBhMCY24wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAPFcLIYgYbuz18NEMcn7hopBOcUWQt0mmfjyWWJPCr5C5UltMfyXO2yPJb1EnAbfCDe72vQpl++DpvJwMlPCwnkoQGYs/SEtZYyYiiIhGOh5YRTCN0HJJlkwBkp2HE6EXTcdbUCA+ppwDsqsv+VUr63fKF45U+qOtempmT/u/uX1AgMBAAGjgaEwgZ4wEQYJYIZIAYb4QgEBBAQDAgWgMAkGA1UdEwQCMAAwUgYDVR0fBEswSTBHoEWgQ6RBMD8xDjAMBgNVBAMMBWNybDE2MQwwCgYDVQQLDANjcmwxEjAQBgNVBAoMCXN5bjA4MDkyNDELMAkGA1UEBhMCY24wCwYDVR0PBAQDAgbAMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDANBgkqhkiG9w0BAQUFAAOCAQEAnSkwt7bs/8GvdmGSmX8N6D+t8fO33OJVDtynhZr03kySffhwCLd221lDf4lauLyeut8wigqWmPEBGtQ8xRn+RqlTnDpRFBlAqD6TbeKjdrZ5ZvTH2fEXes7duZTAHu7I7yPqoc9wMK2il3sai30NntusE1aUDy92V4qM1BQSB1PDYGMJ8Hz1N2OU7uMKSP0KiOs6jwzbKxp3jjqPgFfR8W05UVnzISp6XbqRFCArf0a8ErvQGy41eom0bN/2itQBqe4GyvhFnFkzQ9L8Lru+atzzfFTKCO90WwOFZICvJMAZakrqgQrvMdCLUcB7glVN4TfyLYoOt1s0bGNLSk6F+w==";
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509", "INFOSEC").generateCertificate(new ByteArrayInputStream(Base64.decode((byte[])certStr.getBytes())));
        if (cert == null) {
            System.out.println("cert null");
        }
        NetSignResult res = NetSignAgent.rawSignature(new FileInputStream("d:/TEMP/1.txt"), "CN=5year,O=syn080924,C=cn", null);
        System.out.println(res.getStringResult("Base64_Signed_Text"));
        res = NetSignAgent.rawVerify(new FileInputStream("d:/TEMP/1.txt"), res.getStringResult("Base64_Signed_Text"), cert, null);
        System.out.println("verify ok");
    }
}

