/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.PBCAgent2G;

public class TestCUPNCP {
    private static String signdn;
    private static String encdn;

    static {
        encdn = signdn = "C=cn,O=INFOSEC Technologies RSA,CN=10year";
    }

    public static void main(String[] args) throws Exception {
        TestCUPNCP.testSign();
    }

    private static PBCAgent2G connectServer() {
        PBCAgent2G agent = new PBCAgent2G();
        agent.openSignServer("10.20.61.171", 10001, "12345678");
        return agent;
    }

    private static void testClientDebug() {
        PBCAgent2G agent = TestCUPNCP.connectServer();
        agent.clientDebug("a debug msg".getBytes());
        agent.closeSignServer();
    }

    private static void testVerify() throws Exception {
        PBCAgent2G agent = TestCUPNCP.connectServer();
        byte[] plain = "<root><MsgHeader><MsgVer>1000</MsgVer><SndDt>2017-08-10T10:55:10</SndDt><Trxtyp>0001</Trxtyp><IssrId>00010000</IssrId><Drctn>11</Drctn><SignSN>4000370700</SignSN><EncSN></EncSN><EncKey></EncKey><MDAlgo>1</MDAlgo><SignEncAlgo>1</SignEncAlgo><EncAlgo></EncAlgo></MsgHeader><MsgBody><BizTp>100001</BizTp><TrxInf><TrxId>0810105510000051</TrxId><TrxDtTm>2017-08-10T10:55:10</TrxDtTm><SettlmtDt>2017-08-10</SettlmtDt><TrxAmt></TrxAmt></TrxInf><RcverInf><RcverAcctIssrId>03039200</RcverAcctIssrId><RcverAcctId>6288888888888888</RcverAcctId><RcverNm>\u5f20\u5c0f\u5c0f</RcverNm><IDTp>01</IDTp><IDNo>410482198302100584</IDNo><MobNo>13201569405</MobNo></RcverInf><SensInf></SensInf><SderInf><SderIssrId>W0ACQ001</SderIssrId><SderAcctIssrId>W0ACQ001</SderAcctIssrId><SderAcctIssrNm>\u6d4b\u8bd5\u673a\u6784</SderAcctIssrNm></SderInf><CorpCard><CorpName></CorpName><USCCode></USCCode></CorpCard><ProductInf><ProductTp>00000000</ProductTp><ProductAssInformation>\u94f6\u8054\u5728\u7ebf\u652f\u4ed8</ProductAssInformation></ProductInf><MrchntInf><MrchntNo></MrchntNo><MrchntTpId></MrchntTpId><MrchntPltfrmNm></MrchntPltfrmNm></MrchntInf><SubMrchntInf><SubMrchntNo></SubMrchntNo><SubMrchntTpId></SubMrchntTpId><SubMrchntPltfrmNm></SubMrchntPltfrmNm></SubMrchntInf><RskInf><deviceMode>\u8bbe\u5907\u578b\u53f7</deviceMode><deviceLanguage>zho</deviceLanguage><sourceIP>127.0.0.1</sourceIP><MAC>00-24-7E-0A-6C-2E</MAC><devId>SEID</devId><extensiveDeviceLocation>+37.12/-121.23</extensiveDeviceLocation><deviceNumber>13888888888</deviceNumber><deviceSIMNumber>4</deviceSIMNumber><accountIDHash>456</accountIDHash><riskScore>0</riskScore><riskReasonCode>\u539f\u56e0\u7801</riskReasonCode><mchntUsrRgstrTm>20170711171100</mchntUsrRgstrTm><mchntUsrRgstrEmail>3836255@qq.com</mchntUsrRgstrEmail><rcvProvince>2900</rcvProvince><rcvCity>2900</rcvCity><goodsClass>0</goodsClass></RskInf></MsgBody></root>".getBytes("UTF-8");
        String signed = "EmNWaI/JnsX9Jpt5FmujyalpkpmhYbWvElXasWyUjO9Kwsr+npFYa71r20TnVBIEHxyWssBTHT8Dxspi8kIy/w==";
        boolean ret = agent.CUPNCPRawVerify(plain, signed, "4000370700", "1");
        agent.CUPNCPRawVerify(plain, signed, "4000370700", "1");
        agent.CUPNCPRawVerify(plain, signed, "4000370700", "1");
        System.out.println("verify result:" + ret);
        agent.closeSignServer();
    }

    private static void testEnc() {
        PBCAgent2G agent = TestCUPNCP.connectServer();
        byte[] plain = "12345678952432".getBytes();
        String[] enced = agent.CUPNCPEncrypt(plain, encdn, "1");
        System.out.println("enckey:" + enced[0]);
        System.out.println("encmsg:" + enced[1]);
    }

    private static void testSign2(PBCAgent2G agent) {
        String sig = agent.rawSign("12345678".getBytes(), signdn);
        System.out.println("returncode:" + agent.getReturnCode());
        System.out.println("sig:" + sig);
    }

    private static void testSign() {
        PBCAgent2G agent = TestCUPNCP.connectServer();
        String sig = agent.CUPNCPRawSign("12345678".getBytes(), signdn, "0");
        System.out.println("returncode:" + agent.getReturnCode());
        System.out.println("sig:" + sig);
        boolean ret = agent.CUPNCPRawVerify("12345678".getBytes(), sig, signdn, "0");
        System.out.println("returncode:" + agent.getReturnCode());
        System.out.println("ret:" + ret);
        agent.closeSignServer();
    }
}

