/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class JSBankHanGuanSignVerify {
    public static final String TRANS_SIGN_DN = "123";
    public static final String OPERATION_SIGN_DN = "456";
    public static PublicKey TRANS_VERIFY_KEY;
    private static final String TRANS_VERIFY_CERT_B64 = "xxxx";
    public static PublicKey OPERATION_VERIFY_KEY;
    private static final String OPERATION_VERIFY_CERT_B64 = "xxxx";

    static {
        try {
            NetSignAgent.initialize("/etc/netsignagent.properties");
        }
        catch (NetSignAgentException e) {
            e.printStackTrace();
            throw new RuntimeException("Init infosec netsignagent failed");
        }
        try {
            X509Certificate cert = NetSignAgent.generateCertificate("xxxx".getBytes());
            System.out.println("Certificate for trans verify " + cert.getSubjectDN());
            TRANS_VERIFY_KEY = cert.getPublicKey();
            cert = NetSignAgent.generateCertificate("xxxx".getBytes());
            System.out.println("Certificate for operation verify " + cert.getSubjectDN());
            OPERATION_VERIFY_KEY = cert.getPublicKey();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Init verify certificate failed");
        }
    }

    public static String sign(byte[] plainText, String subject) throws NetSignAgentException, ServerProcessException {
        NetSignResult res = NetSignAgent.rawSignature(plainText, subject, false);
        return res.getStringResult("Base64_Signed_Text");
    }

    public static void verify(byte[] plainText, String signedText, PublicKey key) throws NetSignAgentException, ServerProcessException {
        NetSignAgent.rawVerify(plainText, signedText, null, key);
    }
}

