/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.basic;

import cn.com.infosec.netsign.agent.basic.ShortConnectionSocketHandler;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.LinkedList;

public class PooledConnectionSocketHandler
extends ShortConnectionSocketHandler {
    private int maxConnections;
    private int usedConnection = 0;
    private Object lock = new Object();
    private LinkedList sockets;

    public PooledConnectionSocketHandler(SocketAddress sa, int maxConnections, int connTimeout, int soTimeout) {
        super(sa, connTimeout, soTimeout);
        this.maxConnections = maxConnections;
        this.sockets = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (this.usedConnection >= this.maxConnections) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                    throw new IOException(e.toString());
                }
            }
            Socket s = null;
            s = this.sockets.size() > 0 ? (Socket)this.sockets.removeFirst() : this.newSocket();
            ++this.usedConnection;
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Socket s) {
        Object object = this.lock;
        synchronized (object) {
            this.sockets.add(s);
            --this.usedConnection;
            try {
                this.lock.notifyAll();
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClose(Socket s) {
        Object object = this.lock;
        synchronized (object) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            --this.usedConnection;
            try {
                this.lock.notifyAll();
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
        }
    }
}

