package com.clx.performance.service.impl.integral;

import com.alibaba.fastjson.JSON;
import com.clx.performance.dao.integral.IntegralRuleDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.integral.IntegralRule;
import com.clx.performance.param.pc.integral.IntegralRuleUpdateParam;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class IntegralRuleServiceImpl implements IntegralRuleService {

    @Autowired
    private IntegralRuleDao integralRuleDao;

    @Override
    public void updateRule(IntegralRuleUpdateParam param) {
        IntegralRule rule = integralRuleDao.getEntityByKey(1).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        rule.setOrderChildCompleteRuleJson(JSON.toJSONString(param.getOrderChildCompleteRule()));
        rule.setOrderAwardRuleJson(JSON.toJSONString(param.getOrderAwardRule()));
        rule.setOrderDiscountRuleJson(JSON.toJSONString(param.getOrderDiscountRule()));
        rule.setOrderChildTimeoutRuleJson(JSON.toJSONString(param.getOrderChildTimeoutRule()));
        rule.setPlatformCompensationRuleJson(JSON.toJSONString(param.getPlatformCompensationRule()));
        rule.setDriverRuleJson(JSON.toJSONString(param.getDriverReportRule()));

        integralRuleDao.update(rule);
    }

    @Override
    public AppIntegralRuleVO getRuleInfo() {
        IntegralRule rule = integralRuleDao.getEntityByKey(1).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        AppIntegralRuleVO vo = new AppIntegralRuleVO();
        vo.setOrderChildCompleteRule(JSON.parseObject(rule.getOrderChildCompleteRuleJson(), AppIntegralRuleVO.OrderChildCompleteRule.class));
        vo.setOrderAwardRule(JSON.parseObject(rule.getOrderAwardRuleJson(), AppIntegralRuleVO.OrderAwardRule.class));
        vo.setOrderChildCancelRule(JSON.parseObject(rule.getOrderDiscountRuleJson(), AppIntegralRuleVO.OrderChildCancelRule.class));
        vo.setOrderChildTimeoutRule(JSON.parseObject(rule.getOrderChildTimeoutRuleJson(), AppIntegralRuleVO.OrderChildTimeoutRule.class));
        vo.setPlatformCompensationRule(JSON.parseObject(rule.getPlatformCompensationRuleJson(), AppIntegralRuleVO.PlatformCompensationRule.class));
        vo.setDriverReportRule(JSON.parseObject(rule.getDriverRuleJson(), AppIntegralRuleVO.DriverReportRule.class));

        return vo;
    }

}
