package com.clx.performance.service.impl.collect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.collect.CollectTruckWaitDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.collect.CollectTruckWait;
import com.clx.performance.param.app.collect.CollectLineReportTruckWaitAuditParam;
import com.clx.performance.param.app.collect.CollectWaitReportReceiveAddressSaveParam;
import com.clx.performance.param.app.collect.CollectWaitReportSendAddressSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckWaitParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam;
import com.clx.performance.service.collect.CollectWaitReportService;
import com.clx.performance.struct.collect.CollectTruckWaitStruct;
import com.clx.performance.vo.pc.collect.CollectTruckWaitVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class CollectWaitReportServiceImpl implements CollectWaitReportService {

    @Autowired
    private CollectTruckWaitDao collectTruckWaitDao;
    @Autowired
    private OrderChildDao orderChildDao;

    @Autowired
    private CollectTruckWaitStruct collectTruckWaitStruct;


    @Override
    public void saveSendAddressReport(CollectWaitReportSendAddressSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectTruckWait collectTruckWait = new CollectTruckWait();
        collectTruckWait.setUserNo(userNo);
        collectTruckWait.setName(loginUserInfo.getUserName());
        collectTruckWait.setMobile(loginUserInfo.getUserMobile());
        collectTruckWait.setTruckNo(orderChild.getTruckNo());

        collectTruckWait.setChildNo(param.getChildNo());
        collectTruckWait.setAddressId(orderChild.getSendAddressId());
        collectTruckWait.setAddress(orderChild.getSendAddress());

        collectTruckWait.setReportType(CollectTruckWait.ReportType.LOAD.getCode());
        collectTruckWait.setWaitType(param.getWaitType());

        collectTruckWait.setStationInTime(param.getStationInTime());
        collectTruckWait.setStationInImage(param.getStationInImageList()==null? null : JSON.toJSONString(param.getStationInImageList()));

        collectTruckWait.setReportTime(LocalDateTime.now());
        collectTruckWait.setCreateTime(collectTruckWait.getReportTime());
        collectTruckWaitDao.saveEntity(collectTruckWait);
    }

    @Override
    public void saveReceiveAddressReport(CollectWaitReportReceiveAddressSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectTruckWait collectTruckWait = new CollectTruckWait();
        collectTruckWait.setUserNo(userNo);
        collectTruckWait.setName(loginUserInfo.getUserName());
        collectTruckWait.setMobile(loginUserInfo.getUserMobile());
        collectTruckWait.setTruckNo(orderChild.getTruckNo());

        collectTruckWait.setChildNo(param.getChildNo());
        collectTruckWait.setAddressId(orderChild.getSendAddressId());
        collectTruckWait.setAddress(orderChild.getSendAddress());

        collectTruckWait.setReportType(CollectTruckWait.ReportType.UNLOAD.getCode());
        collectTruckWait.setWaitType(param.getWaitType());

        collectTruckWait.setStationOutTime(param.getStationOutTime());
        collectTruckWait.setStationOutImage(param.getStationOutImageList()==null? null:JSON.toJSONString(param.getStationOutImageList()));

        collectTruckWait.setReportTime(LocalDateTime.now());
        collectTruckWait.setCreateTime(collectTruckWait.getReportTime());
        collectTruckWaitDao.saveEntity(collectTruckWait);
    }

    @Override
    public CollectTruckWaitVO getReportInfo(Integer id) {
        return collectTruckWaitDao.getEntityByKey(id).map(collectTruckWaitStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

    }

    @Override
    public IPage<CollectTruckWaitVO> pageWaitReport(PageCollectTruckWaitParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTruckWaitDao.pageWaitReport(param);
    }

    @Override
    public void updateWaitReportAudit(CollectLineReportTruckWaitAuditParam param) {
        CollectTruckWait report = collectTruckWaitDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        report.setAuditStatus(CollectTruckWait.AuditStatus.AUDIT.getCode());
        collectTruckWaitDao.updateAuditStatus(report);
    }

    @Override
    public IPage<CollectTruckWaitVO> carrierPageWaitReport(CarrierPageCollectTruckWaitParam param) {
        return collectTruckWaitDao.carrierPageWaitReport(param);

    }
}
