package com.clx.performance.service.impl.collect;

import com.clx.performance.dao.collect.CollectTruckDao;
import com.clx.performance.model.collect.CollectTruck;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.service.collect.CollectTruckReportService;
import com.clx.performance.struct.collect.CollectTruckStruct;
import com.clx.performance.vo.app.collect.AppCollectTruckVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class CollectTruckReportServiceImpl implements CollectTruckReportService {

    @Autowired
    private CollectTruckDao collectTruckDao;

    @Autowired
    private CollectTruckStruct collectTruckStruct;

    @Override
    public void updateUnloadType(CollectTruckUnloadTypeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setUnloadType(param.getUnloadType());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateAutoLoanStatus(CollectAutoLoanStatusUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setAutoLoanStatus(param.getAutoLoanStatus());
        truck.setAutoLoanMonth(param.getAutoLoanMonth());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateParkAddress(CollectTruckReportParkAddressUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setParkAddress(param.getParkAddress());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateOverTonnageType(CollectTruckReportOverTonnageTypeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setOverTonnageType(param.getOverTonnageType());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateDistanceUsualPlaceMax(CollectTruckReportDistanceUsualPlaceMaxUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setDistanceUsualPlaceMax(param.getDistanceUsualPlaceMax());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateDistanceLineMax(CollectTruckReportDistanceLineMaxUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setDistanceLineMax(param.getDistanceLineMax());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateDistanceSendAddressMax(CollectTruckReportDistanceSendAddressMaxUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setDistanceSendAddressMax(param.getDistanceSendAddressMax());
        collectTruckDao.update(truck);
    }

    @Override
    public void updateGoodsType(CollectTruckReportGoodsTypeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setGoodsType(param.getGoodsType());
        collectTruckDao.update(truck);
    }

    @Override
    public AppCollectTruckVO getReportInfo(String truckNo) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, truckNo).orNull();

        return collectTruckStruct.convertAppCollectTruckVO(truck);

    }

}
