package com.clx.performance.service.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.collect.CollectTruckLeaveDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.collect.CollectTruckLeave;
import com.clx.performance.param.app.collect.CollectTruckLeaveSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckLeaveParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLeaveParam;
import com.clx.performance.service.collect.CollectTruckLeaveService;
import com.clx.performance.struct.collect.CollectTruckLeaveStruct;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.collect.CollectTruckLeaveVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class CollectTruckLeaveServiceImpl implements CollectTruckLeaveService {

    @Autowired
    private CollectTruckLeaveDao collectTruckLeaveDao;

    @Autowired
    private CollectTruckLeaveStruct collectTruckLeaveStruct;


    @Override
    public void saveLeave(CollectTruckLeaveSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        CollectTruckLeave collectTruckLeave = new CollectTruckLeave();
        collectTruckLeave.setUserNo(userNo);
        collectTruckLeave.setName(loginUserInfo.getUserName());
        collectTruckLeave.setMobile(loginUserInfo.getUserMobile());
        collectTruckLeave.setTruckNo("");

        collectTruckLeave.setBeginTime(LocalDateTimeUtils.parseTime(param.getBeginTime()));
        collectTruckLeave.setEndTime(LocalDateTimeUtils.parseTime(param.getEndTime()));
        collectTruckLeave.setRemark(param.getRemark());
        collectTruckLeaveDao.saveEntity(collectTruckLeave);
    }

    @Override
    public CollectTruckLeaveVO getInfo(Integer id) {
        return collectTruckLeaveDao.getEntityByKey(id).map(collectTruckLeaveStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

    }

    @Override
    public IPage<CollectTruckLeaveVO> pageLeave(PageCollectTruckLeaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTruckLeaveDao.pageLeave(param);
    }

    @Override
    public IPage<CollectTruckLeaveVO> carrierPageLeave(CarrierPageCollectTruckLeaveParam param) {
        return collectTruckLeaveDao.carrierPageLeave(param);

    }
}
