package com.clx.performance.service.impl.collect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.collect.CollectTrafficCongestionDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.collect.CollectTrafficCongestion;
import com.clx.performance.param.app.collect.CollectTrafficCongestionAuditParam;
import com.clx.performance.param.app.collect.CollectTrafficCongestionSaveParam;
import com.clx.performance.param.app.collect.PageCollectTraficCongestionParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTraficCongestionParam;
import com.clx.performance.service.collect.CollectTrafficCongestionService;
import com.clx.performance.struct.collect.CollectTrafficCongestionStruct;
import com.clx.performance.vo.pc.collect.CollectTrafficCongestionVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;

@Slf4j
@Service
public class CollectTrafficCongestionServiceImpl implements CollectTrafficCongestionService {

    @Autowired
    private CollectTrafficCongestionDao collectTrafficCongestionDao;

    @Autowired
    private CollectTrafficCongestionStruct collectTrafficCongestionStruct;


    @Override
    public void saveTrafficReport(CollectTrafficCongestionSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        CollectTrafficCongestion collectTrafficCongestion = new CollectTrafficCongestion();
        collectTrafficCongestion.setUserNo(userNo);
        collectTrafficCongestion.setName(loginUserInfo.getUserName());
        collectTrafficCongestion.setMobile(loginUserInfo.getUserMobile());

        collectTrafficCongestion.setTruckNo("");

        collectTrafficCongestion.setLongitude(param.getLongitude());
        collectTrafficCongestion.setLatitude(param.getLatitude());
        collectTrafficCongestion.setProvince(param.getProvince());
        collectTrafficCongestion.setCity(param.getCity());
        collectTrafficCongestion.setCounty(param.getCounty());
        collectTrafficCongestion.setTown(param.getTown());
        collectTrafficCongestion.setStreet(param.getStreet());
        collectTrafficCongestion.setAddress(param.getAddress());
        collectTrafficCongestion.setFullAddress("");

        if (!StringUtils.isEmpty(param.getProvince())){collectTrafficCongestion.setFullAddress(collectTrafficCongestion.getFullAddress()+param.getProvince());}
        if (!StringUtils.isEmpty(param.getCity())){collectTrafficCongestion.setFullAddress(collectTrafficCongestion.getFullAddress()+param.getCity());}
        if (!StringUtils.isEmpty(param.getCounty())){collectTrafficCongestion.setFullAddress(collectTrafficCongestion.getFullAddress()+param.getCounty());}
        if (!StringUtils.isEmpty(param.getTown())){collectTrafficCongestion.setFullAddress(collectTrafficCongestion.getFullAddress()+param.getTown());}
        if (!StringUtils.isEmpty(param.getStreet())){collectTrafficCongestion.setFullAddress(collectTrafficCongestion.getFullAddress()+param.getStreet());}
        if (!StringUtils.isEmpty(param.getAddress())){collectTrafficCongestion.setFullAddress(collectTrafficCongestion.getFullAddress()+param.getAddress());}


        collectTrafficCongestion.setJamTime(param.getJamTime());
        collectTrafficCongestion.setJamImage(param.getJamImageList()==null? null:JSON.toJSONString(param.getJamImageList()));
        collectTrafficCongestion.setReportTime(LocalDateTime.now());
        collectTrafficCongestion.setCreateTime(collectTrafficCongestion.getReportTime());
        collectTrafficCongestionDao.saveEntity(collectTrafficCongestion);
    }

    @Override
    public CollectTrafficCongestionVO getReportInfo(Integer id) {
        return collectTrafficCongestionDao.getEntityByKey(id).map(collectTrafficCongestionStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

    }

    @Override
    public IPage<CollectTrafficCongestionVO> pageTrafficReport(PageCollectTraficCongestionParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTrafficCongestionDao.pageTraffic(param);
    }

    @Override
    public void updateTrafficCongestionAudit(CollectTrafficCongestionAuditParam param) {
        CollectTrafficCongestion collectTrafficCongestion = collectTrafficCongestionDao.getEntityByKey(param.getId()).orElseThrow();
        collectTrafficCongestion.setAuditStatus(CollectTrafficCongestion.AuditStatus.AUDIT.getCode());
        collectTrafficCongestionDao.updateAuditStatus(collectTrafficCongestion);
    }

    @Override
    public IPage<CollectTrafficCongestionVO> carrierPageTrafficReport(CarrierPageCollectTraficCongestionParam param) {
        return collectTrafficCongestionDao.carrierPageTraffic(param);
    }

}
