package com.clx.performance.controller.app;

import com.clx.performance.param.app.collect.*;
import com.clx.performance.service.collect.CollectTruckReportService;
import com.clx.performance.vo.app.collect.AppCollectTruckVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/truck")
@Validated
@Api(tags = "APP-车辆上报")
@AllArgsConstructor
public class AppDriverCollectTruckController {

    private final CollectTruckReportService collectTruckReportService;

    @ApiOperation(value = "更新卸车方式", notes = "<br>By:艾庆国")
    @PostMapping("/updateUnloadType")
    public Result<Void> updateUnloadType(@RequestBody @Validated CollectTruckUnloadTypeUpdateParam param) {
        collectTruckReportService.updateUnloadType(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新车贷情况", notes = "<br>By:艾庆国")
    @PostMapping("/updateAutoLoanStatus")
    public Result<Void> updateAutoLoanStatus(@RequestBody @Validated CollectAutoLoanStatusUpdateParam param) {
        collectTruckReportService.updateAutoLoanStatus(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新车辆停放位置", notes = "<br>By:艾庆国")
    @PostMapping("/updateParkAddress")
    public Result<Void> updateParkAddress(@RequestBody @Validated CollectTruckReportParkAddressUpdateParam param) {
        collectTruckReportService.updateParkAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新拉运方式", notes = "<br>By:艾庆国")
    @PostMapping("/updateOverTonnageType")
    public Result<Void> updateOverTonnageType(@RequestBody @Validated CollectTruckReportOverTonnageTypeUpdateParam param) {
        collectTruckReportService.updateOverTonnageType(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新接受距常驻地最远距离", notes = "<br>By:艾庆国")
    @PostMapping("/updateUsualPlaceDistanceMax")
    public Result<Void> updateDistanceUsualPlaceMax(@RequestBody @Validated CollectTruckReportDistanceUsualPlaceMaxUpdateParam param) {
        collectTruckReportService.updateDistanceUsualPlaceMax(param);

        return Result.ok();
    }
    @ApiOperation(value = "更新单次任务接受最远距离", notes = "<br>By:艾庆国")
    @PostMapping("/updateLineDistanceMax")
    public Result<Void> updateDistanceLineMax(@RequestBody @Validated CollectTruckReportDistanceLineMaxUpdateParam param) {
        collectTruckReportService.updateDistanceLineMax(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新接受距货源地最远距离", notes = "<br>By:艾庆国")
    @PostMapping("/updateSendAddressDistanceMax")
    public Result<Void> updateDistanceSendAddressMax(@RequestBody @Validated CollectTruckReportDistanceSendAddressMaxUpdateParam param) {
        collectTruckReportService.updateDistanceSendAddressMax(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新接受距货源地最远距离", notes = "<br>By:艾庆国")
    @PostMapping("/updateGoodsType")
    public Result<Void> updateGoodsType(@RequestBody @Validated CollectTruckReportGoodsTypeUpdateParam param) {
        collectTruckReportService.updateGoodsType(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询车辆详情", notes = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<AppCollectTruckVO> getReportInfo(@Validated @NotBlank(message = "车牌不能为空") String truckNo) {

        return Result.ok(collectTruckReportService.getReportInfo(truckNo));

    }

}
