package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 司机积分-mq
 * @Date: 2023-10-12 15:27:23
 * @Version: 1.0
 */
public class RabbitKeyIntegralConstants {

    private static final String PREFIX = "clx-performance.integral.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeyIntegralConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 新增积分车辆
     */
    public static final String INTEGRAL_TRUCK_ADD_QUEUE = PREFIX +"truck.add"+QUEUE;
    public static final String INTEGRAL_TRUCK_ADD_ROUTING_KEY = PREFIX +"truck.add"+QUEUE_ROUTING_KEY;

    /**
     * 新增积分货单
     */
    public static final String INTEGRAL_ORDER_GOODS_ADD_QUEUE = PREFIX +"orderGoods.add"+QUEUE;
    public static final String INTEGRAL_ORDER_GOODS_ADD_ROUTING_KEY = PREFIX +"orderGoods.add"+QUEUE_ROUTING_KEY;

    /**
     * 新增积分记录
     */
    public static final String INTEGRAL_RECORD_ADD_QUEUE = PREFIX +"record.add"+QUEUE;
    public static final String INTEGRAL_RECORD_ADD_ROUTING_KEY = PREFIX +"record.add"+QUEUE_ROUTING_KEY;


    /**
     * 下周车辆初始化
     */
    public static final String INTEGRAL_NEXT_WEEK_TRUCK_INIT_QUEUE = PREFIX +"nextWeekTruck.init"+QUEUE;
    public static final String INTEGRAL_NEXT_WEEK_TRUCK_INIT_ROUTING_KEY = PREFIX +"nextWeekTruck.init"+QUEUE_ROUTING_KEY;


    /**
     * 积分周统计
     */
    public static final String INTEGRAL_WEEK_TRUCK_STATISTICS_QUEUE = PREFIX +"weekTruck.statistics"+QUEUE;
    public static final String INTEGRAL_WEEK_TRUCK_STATISTICS_ROUTING_KEY = PREFIX +"weekTruck.statistics"+QUEUE_ROUTING_KEY;

    /**
     * 新车保护取消
     */
    public static final String INTEGRAL_TRUCK_PROTECTION_CANCEL_QUEUE = PREFIX +"truckProtection.cancel"+QUEUE;
    public static final String INTEGRAL_TRUCK_PROTECTION_CANCEL_ROUTING_KEY = PREFIX +"truckProtection.cancel"+QUEUE_ROUTING_KEY;

    /**
     * 运单结束
     */
    public static final String INTEGRAL_ORDER_CHILD_FINISH_QUEUE = PREFIX +"orderChild.finish"+QUEUE;
    public static final String INTEGRAL_ORDER_CHILD_FINISH_ROUTING_KEY = PREFIX +"orderChild.finish"+QUEUE_ROUTING_KEY;


    /**
     * 实时积分统计
     */
    public static final String INTEGRAL_REAL_TIME_STATISTICS_QUEUE = PREFIX +"integralRealTime.statistics"+QUEUE;
    public static final String INTEGRAL_REAL_TIME_STATISTICS_ROUTING_KEY = PREFIX +"integralRealTime.statistics"+QUEUE_ROUTING_KEY;

}
