package com.clx.performance.enums.collect;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum CollectTruckWaitEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum ReportType {
        LOAD(1, "装车类型"),
        UNLOAD(2, "卸车类型");
        private final Integer code;
        private final String msg;

        public static Optional<ReportType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum waitType {
        LOAD(1, "装车类型"),
        UNLOAD(2, "卸车类型");
        private final Integer code;
        private final String msg;

        public static Optional<waitType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum AuditStatus {
        UNAUDIT(0, "待审核"),
        AUDIT(1, "已审核");
        private final Integer code;
        private final String msg;

        public static Optional<AuditStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
