package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OrderGoodsLogDao;
import com.clx.performance.model.OrderGoodsLog;
import com.clx.performance.param.pc.OrderGoodsLogParam;
import com.clx.performance.service.OrderGoodsLogService;
import com.clx.performance.struct.OrderGoodsLogStruct;
import com.clx.performance.vo.pc.OrderGoodsLogVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author kavin
 * Date 2023-10-26
 * Time 11:27
 */
@Service
@Slf4j
@AllArgsConstructor
public class OrderGoodsLogServiceImpl implements OrderGoodsLogService {

    OrderGoodsLogDao orderGoodsLogDao;

    OrderGoodsLogStruct orderGoodsLogStruct;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveLog(String orderGoodsNo, Long userNo, String userName, String type, String remark) {
        OrderGoodsLog log = OrderGoodsLog.builder().orderGoodsNo(orderGoodsNo).createBy(userNo).createName(userName).type(type).remark(remark).build();
        orderGoodsLogDao.saveEntity(log);

    }

    @Override
    public IPage<OrderGoodsLogVO> pageOrderGoodsLog(OrderGoodsLogParam param) {
        Page<OrderGoodsLog> page = orderGoodsLogDao.pageOrderGoodsLog(Page.of(param.getPage(), param.getPageSize()),param.getOrderGoodsNo());
        List<OrderGoodsLogVO> orderGoodsLogVOS = orderGoodsLogStruct.covertList(page.getRecords());
        Page<OrderGoodsLogVO> result = new Page<>();
        result.setTotal(page.getTotal());
        result.setPages(page.getPages());
        result.setRecords(orderGoodsLogVOS);
        return result;
    }
}
