package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.clx.performance.enums.DriverTruckEnum;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.*;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;

/**
* @Author: aiqinguo
* @Description: 线路信息上报
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CollectLineReport implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private String name;                            //用户姓名
    private String mobile;                          //手机号码
    private String truckNo;                         //车牌号
    private String orderGoodsNo;                    //货单编号
    private String childNo;                         //运单编号
    private Integer addressId;                      //地址id
    private String address;                         //详细地址
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private Integer type;                           //类型：1 发货地 2 目的地
    private Integer reportType;                     //上报类型：1:无法到达货源地 2:无法装货 3：无法到达目的地  4：运单取消  5：装车卸车异常  6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报
    private Integer reportStatus;                   //拉运状态 1: 正常 2：异常
    private String remark;                          //状态描述
    private String image;                           //上报图片
    private LocalDateTime reportTime;               //上报时间
    private Integer auditStatus;                    //审核状态：0待审核 1已审核
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

    @Getter
    @AllArgsConstructor
    public enum Type {
        SEND(1, "发货地"),
        RECEIVE(2, "目的地");
        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    //1:无法到达货源地 2:无法装货 3：无法到达目的地  4：运单取消  5：装车卸车异常  6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报
    @Getter
    @AllArgsConstructor
    public enum ReportType {
        UNABLE_TO_SEND_ADDRESS(1, "无法到达货源地"),
        UNABLE_LOAD(2, "无法装货"),
        UNABLE_TO_RECEIVE_ADDRESS(3, "无法到达目的地"),
        LOAD_UNLOAD(4, "装车卸车异常"),

        NO_TAKE_ORDER(6, "没有接单"),
        SEND_ADDRESS(7, "货源地情况"),

        OTHER(8, "其它上报"),
        QUALITY(9, "煤炭质量上报"),

        ;
        private final Integer code;
        private final String msg;

        public static Optional<ReportType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum ReportStatus {
        NORMAL(1, "正常"),
        ABNORMAL(2, "异常");
        private final Integer code;
        private final String msg;

        public static Optional<ReportStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum AuditStatus {
        UNAUDIT(0, "待审核"),
        AUDIT(1, "已审核");
        private final Integer code;
        private final String msg;

        public static Optional<AuditStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}