package com.clx.performance.listener.breakcontract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyBreakContractConstants;
import com.clx.performance.param.mq.BreakContractDriverRecordAddMqParam;
import com.clx.performance.service.breakcontract.BreakContractMqHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 司机违约记录新增 mq
 * @Date: 2023-10-20 11:45:08
 * @Version: 1.0
 */
@Slf4j
@Component
public class BreakContractDriverRecordAddListener {

    @Autowired
    private BreakContractMqHandlerService breakContractMqHandlerService;

    @RabbitListener(queues = RabbitKeyBreakContractConstants.DRIVER_RECORD_ADD_QUEUE)
    public void process(Message message) {
        try{
            log.info("违约-司机违约记录创建, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<BreakContractDriverRecordAddMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("违约-司机违约记录创建 失败",e);
        }
    }

    private void process(BreakContractDriverRecordAddMqParam mq){

        breakContractMqHandlerService.driverRecordAdd(mq);

    }
}
