package com.clx.performance.extranal.transport.impl;

import com.clx.performance.extranal.transport.TransportService;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.param.feign.transport.ThirdOrderChildBrokerParam;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class TransportServiceImpl implements TransportService {

    @Autowired
    private TransportFeignService transportFeignService;


    @Override
    public void orderChildSync(ThirdOrderChildBrokerParam param) {
        Optional.ofNullable(transportFeignService.orderChildSync(param))
                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL);

    }
}
