package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractDriverRecordDao;
import com.clx.performance.mapper.breakcontract.BreakContractDriverRecordMapper;
import com.clx.performance.model.breakcontract.BreakContractDriverRecord;
import com.clx.performance.param.app.breakcontract.DriverPageBreakContractDriverRecordParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractDriverRecordParam;
import com.clx.performance.vo.app.breakcontract.DriverBreakContractDriverRecordVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRecordVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractDriverRecordDaoImpl extends BaseDaoImpl<BreakContractDriverRecordMapper, BreakContractDriverRecord, Integer> implements BreakContractDriverRecordDao {

    @Override
    public boolean updateSettlementNo(BreakContractDriverRecord item) {
        return update(lUdWrapper()
                .eq(BreakContractDriverRecord::getId, item.getId())
                .set(BreakContractDriverRecord::getSettlementNo, item.getSettlementNo())
        );
    }

    @Override
    public Optional<BreakContractDriverRecord> selectLastLimitTimeByDriverUserNo(Long driverUserNo, LocalDateTime time) {
        return Optional.of(driverUserNo)
                .map(item -> lQrWrapper()
                        .eq(BreakContractDriverRecord::getDriverUserNo, item)
                        .isNotNull(BreakContractDriverRecord::getLimitTime)
                        .ge(BreakContractDriverRecord::getLimitTime, time)
                        .orderByDesc(BreakContractDriverRecord::getLimitTime)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public IPage<BreakContractDriverRecordVO> pageByParam(PageBreakContractDriverRecordParam param) {
        Page<BreakContractDriverRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

    @Override
    public IPage<DriverBreakContractDriverRecordVO> driverPageByParam(DriverPageBreakContractDriverRecordParam param) {
        Page<DriverBreakContractDriverRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.driverPageByParam(page,param);
    }

}
