package com.clx.performance.dao.impl;

import com.clx.performance.dao.SeniorLogisticsManagerDao;
import com.clx.performance.dao.ThirdPartRequestLogDao;
import com.clx.performance.enums.ThirdRequestStatusEnum;
import com.clx.performance.enums.ThirdRequestTypeEnum;
import com.clx.performance.mapper.SeniorLogisticsManagerMapper;
import com.clx.performance.mapper.ThirdPartRequestLogMapper;
import com.clx.performance.model.SeniorLogisticsManager;
import com.clx.performance.model.ThirdPartRequestLog;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Repository
public class ThirdPartRequestLogDaoImpl extends BaseDaoImpl<ThirdPartRequestLogMapper, ThirdPartRequestLog, Integer> implements ThirdPartRequestLogDao {

    /**
     * 查询发送请求失败的数据
     *
     * @param time
     * @return
     */
    @Override
    public List<ThirdPartRequestLog> listThirdPartRequestLogError(String time) {
        return Optional.ofBlank(time)
                .map(t -> lQrWrapper()
                        .eq(ThirdPartRequestLog::getRequestType, ThirdRequestTypeEnum.SEND.getCode())
                        .le(ThirdPartRequestLog::getRetryTimes, 5)
                        .in(ThirdPartRequestLog::getStatus, ThirdRequestStatusEnum.HAVING.getCode())
                        .le(ThirdPartRequestLog::getCreateTime, t))
                .map(super::list)
                .orElseGet(Collections::emptyList);
    }

    /**
     * 修改重试次数
     *
     * @param logId
     * @param retryTimes
     */
    @Override
    public void updateLogRetryTimes(Integer logId, Integer retryTimes) {
        super.update(lUdWrapper().eq(ThirdPartRequestLog::getId, logId)
                .set(ThirdPartRequestLog::getRetryTimes, retryTimes));
    }

}