package com.clx.performance.controller.feign;

import com.clx.performance.component.GoodsOrderTruckRecordComponent;
import com.clx.performance.service.OrderGoodsTruckBindService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

@RestController
@RequestMapping("/feign/orderGoodsDriverTruck")
@Validated
@Api(tags = "定向车辆Feign")
@AllArgsConstructor
public class TruckFeignController {

    private final OrderGoodsTruckBindService orderGoodsTruckService;

    private final GoodsOrderTruckRecordComponent goodsOrderTruckRecordComponent;

    @Deprecated
    @GetMapping({"/getTrucksByOrderGoodsNo"})
    Result<List<Integer>> getTrucksByOrderGoodsNo(@RequestParam("orderGoodsNo") @NotNull(message = "货单编号不可为空") String orderGoodsNo){
        return Result.ok(orderGoodsTruckService.getTrucksByOrderGoodsNo(orderGoodsNo));
    }

    @GetMapping({"/getPublicTruckList"})
    Result<Set<String>> getPublicTruckList(){
        return Result.ok(goodsOrderTruckRecordComponent.getPublicTruckList());
    }

    @GetMapping({"/getPrivateTruckList"})
    Result<List<String>> getPrivateTruckList(@RequestParam("orderGoodsNo") @NotBlank(message = "货单编号不可为空") String orderGoodsNo,
                                             @RequestParam("userNo") @NotNull(message = "用户编号不可为空") Long userNo){
        return Result.ok(goodsOrderTruckRecordComponent.getPrivateTruckList(orderGoodsNo,userNo));
    }

}
