package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OutputMonitorOrderChildVO {


    @ApiModelProperty(value = "发货地址")
    private String sendAddress;

    @ApiModelProperty(value = "发货地址Id")
    private Integer sendAddressId;


    @ApiModelProperty(value = "状态  运单状态  10：已接单  20:支付 30：前往货源地 40：到达货源地 50：装货成功 60：前往目的地 70：到达目的地 80：收货待确认  90：待结算 100：完成  110:司机取消  111:承运取消   112:货主取消 ")
    private Integer status;

    @ApiModelProperty(value = "预计到货源地时间")
    private String expectArriveTime;

    @ApiModelProperty(value = "预计到货源地时间-实时")
    private String expectArriveTimeRealTime;

    @ApiModelProperty(value = "预计到货源地趋势 0 前进 1 后退")
    private Integer arriveTrend;

    @ApiModelProperty(value = "预计到收货地时间")
    private String expectReceiveTime;

    @ApiModelProperty(value = "预计到收货地时间-实时")
    private String expectReceiveTimeRealTime;

    @ApiModelProperty(value = "预计到收货地趋势 0 前进 1 后退")
    private Integer receiveTrend;

    @ApiModelProperty(value = "预计运输时间")
    private String expectTransportTime;

    @ApiModelProperty(value = "装车预警 0 不预警 1 预警")
    private Integer loadWarning;

    @ApiModelProperty(value = "货源地预警 0 不预警 1 预警")
    private Integer arriveWarning;

    @ApiModelProperty(value = "收货地预警 0 不预警 1 预警")
    private Integer receiveWarning;

    @ApiModelProperty(value = "车牌号")
    private String truckNo;

    @ApiModelProperty(value = "司机姓名")
    private String driverName;

    @ApiModelProperty(value = "司机手机号")
    private String driverMobile;

    @ApiModelProperty(value = "装车吨数")
    private BigDecimal loadNet;

    @ApiModelProperty(value = "接单时间")
    private String payTime;

    @ApiModelProperty(value = "装车时间")
    private String loadTime;

    @ApiModelProperty(value = "运单号")
    private String childNo;

}
