package com.clx.performance.param.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class IntegralOrderAddParam {

    @ApiModelProperty(value = "货单编号", example = "100000000000")
    @NotBlank(message = "车牌号不能为空")
    private String orderGoodsNo;
    @ApiModelProperty(value = "货单类型：1优质单 2普通单 3流水单 4支援单", example = "1")
    @NotNull(message = "货单类型不能为空")
    private Integer orderType;
    @ApiModelProperty(value = "车辆梯队", example = "1")
    @NotNull(message = "车辆梯队不能为空")
    private Integer truckEchelon;

}
