package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class ThirdOrderChildBrokerParam {

    @ApiModelProperty(value = "订单编码", dataType="String", required = true)
    private String childNo;
    @ApiModelProperty(value = "主单编码", dataType="String", required = true)
    private String orderNo;
    @ApiModelProperty(value = "车牌号", dataType="String", required = true)
    private String truckNo;
    @ApiModelProperty(value = "运费单价 单位分", dataType="Integer", required = true)
    private Integer freightPrice;
    @ApiModelProperty(value = "运费 单位分", dataType="Integer", required = true)
    private Integer freight;
    @ApiModelProperty(value = "实付运费 单位分", dataType="Integer", required = true)
    private Integer freightNoCard;
    @ApiModelProperty(value = "溢价金额", dataType = "Integer", required = true)
    private Integer orderChildBrokerBeyondFreight;
    @ApiModelProperty(value = "净重", dataType="BigDecimal", required = true)
    private BigDecimal net;
    @ApiModelProperty(value = "发货地址", dataType="String", required = true)
    private String sendAddress;
    @ApiModelProperty(value = "货源所在省份", dataType="String", required = true)
    private String sendProvince;
    @ApiModelProperty(value = "货源所在城市", dataType="String", required = true)
    private String sendCity;
    @ApiModelProperty(value = "货源所在区县", dataType="String", required = true)
    private String sendCounty;
    @ApiModelProperty(value = "货源所在乡镇", dataType="String", required = true)
    private String sendTown;
    @ApiModelProperty(value = "发货人", dataType="String", required = true)
    private String sendName;
    @ApiModelProperty(value = "发货人手机号", dataType="String", required = true)
    private String sendMobile;
    @ApiModelProperty(value = "收货人所在省", dataType="String", required = true)
    private String receiveProvince;
    @ApiModelProperty(value = "收货人所在城市", dataType="String", required = true)
    private String receiveCity;
    @ApiModelProperty(value = "收货人所在区县", dataType="String", required = true)
    private String receiveCounty;
    @ApiModelProperty(value = "收货人所在乡镇", dataType="String", required = true)
    private String receiveTown;
    @ApiModelProperty(value = "收货地址", dataType="String", required = true)
    private String receiveAddress;
    @ApiModelProperty(value = "收货人", dataType="String", required = true)
    private String receiveName;
    @ApiModelProperty(value = "收货人手机号", dataType="String", required = true)
    private String receiveMobile;
    @ApiModelProperty(value = "装车地址经度", required = true)
    private String loadLongitude;
    @ApiModelProperty(value = "装车地址纬度", required = true)
    private String loadLatitude;
    @ApiModelProperty(value = "卸车地址经度", required = true)
    private String unloadLongitude;
    @ApiModelProperty(value = "卸车地址纬度", required = true)
    private String unloadLatitude;
    @ApiModelProperty(value = "运输距离（公里）", required = true)
    private BigDecimal distance;
    @ApiModelProperty(value = "接单时间", dataType="String", required = true)
    private String payTime;
    @ApiModelProperty(value = "装车时间", dataType="String", required = true)
    private String loadTime;
    @ApiModelProperty(value = "卸车时间", dataType="String", required = true)
    private String unloadTime;
    @ApiModelProperty(value = "支付完成时间", dataType="String", required = true)
    private String payFinishedTime;
    @ApiModelProperty(value = "备注", dataType="String")
    private String remark;
//    @ApiModelProperty(value = "创建时间", dataType="String", required = true)
//    private String createTime;
    @ApiModelProperty(value = "收货单位", dataType="String", required = true)
    private String receiveCompany;
    @ApiModelProperty(value = "发货单位", dataType="String", required = true)
    private String sendCompany;
    @ApiModelProperty(value = "收货净重", dataType="BigDecimal", required = true)
    private BigDecimal receiveNet;
    @ApiModelProperty(value = "货物名称", dataType="String", required = true)
    private String goodsName;
//    @ApiModelProperty(value = "是否车主本人：1是，0否", dataType="Integer", required = true)
//    private Integer personalDriverFlag;
    @ApiModelProperty(value = "垫付类型 0 全额垫付 1 不垫付服务费", dataType="Integer", required = true)
    private Integer advanceType;
    @ApiModelProperty(value = "货物价格 单位 分", required = true)
    private Integer goodsPrice;
    @ApiModelProperty(value = "装车磅单图片", required = true)
    private List<String> loadPoundImages;
    @ApiModelProperty(value = "卸车磅单图片", required = true)
    private List<String> unLoadPoundImages;
    @ApiModelProperty(value = "关联账号", required = true)
    private String invoiceRelationNo;

    @ApiModelProperty(value = "货单信息", required = true)
    private ThirdOrderInfoDTO orderInfoDTO;
    @ApiModelProperty(value = "车主信息", required = true)
    private OrderChildDriverInfoDTO truckDriverInfoDTO;
    @ApiModelProperty(value = "司机信息", required = true)
    private OrderChildDriverInfoDTO driverInfoDTO;
    @ApiModelProperty(value = "车主银行卡信息", required = true)
    private OrderChildBankInfoDTO truckDriverBankInfoDTO;
    @ApiModelProperty(value = "司机银行卡信息", required = true)
    private OrderChildBankInfoDTO driverBankInfoDTO;
    @ApiModelProperty(value = "车辆信息", required = true)
    private OrderChildTruckInfoDTO truckInfoDTO;

    @ApiModelProperty(value = "运单轨迹", required = true)
    private List<OrderChildTruckTraceDTO> brokerTraceList;

    @ApiModelProperty(value = "来源:0-货易来,1-诚联信 2承运", hidden = true)
    private Integer source;

}
