package com.clx.performance.service.impl.settle;

import com.clx.performance.enums.settle.SettlementWayEnum;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.SettlementCommonService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

@Slf4j
@Service
public class SettlementCommonServiceImpl implements SettlementCommonService {

    /**
     * 开票服务费金额
     */
    @Override
    public BigDecimal invoiceServiceFeeCalc(Integer settlementWay, SettlementOwnerDetail settlementOwnerDetail) {
        return settlementOwnerDetail.getFreight().subtract(settlementOwnerDetail.getLossFreight())
                .divide(BigDecimal.ONE.subtract(settlementOwnerDetail.getInvoiceServiceFeeRate().movePointLeft(2)), 0, RoundingMode.HALF_UP)
                .multiply(settlementOwnerDetail.getInvoiceServiceFeeRate().movePointLeft(2)).setScale(0, RoundingMode.HALF_UP);
    }

    /**
     * 开票金额
     */
    @Override
    public BigDecimal invoiceFreightCalc(Integer settlementWay, BigDecimal invoiceServiceFeeRate, SettlementOwnerDetail settlementOwnerDetail) {
        if (Objects.equals(settlementWay, SettlementWayEnum.WayType.LOAD.getCode())) { //订单结算方式为“装车净重”时，开票金额=实际净重*平台运费报价-货损金额。
            return settlementOwnerDetail.getWeight().multiply(settlementOwnerDetail.getFreightPrice())
                    .subtract(settlementOwnerDetail.getLossFreight());
        }
        else if (Objects.equals(settlementWay, SettlementWayEnum.WayType.UNLOAD_LOSS.getCode())) {
            if (invoiceServiceFeeRate!=null){
                //结算方式为“卸车净重（减货损）”，平台运费报价为“未税”时，开票金额=平台运费单价*实际净重-货损单价*货损吨数+开票服务费。
                return settlementOwnerDetail.getWeight().multiply(settlementOwnerDetail.getFreightPrice())
                        .subtract(settlementOwnerDetail.getLossPrice())
                        .add(settlementOwnerDetail.getInvoiceServiceFee());
            }
            else{
                //结算方式为“卸车净重（减货损）”，平台运费报价为“含税”时   开票金额=平台运费单价*实际净重-货损单价*货损吨数
                return settlementOwnerDetail.getWeight().multiply(settlementOwnerDetail.getFreightPrice())
                        .subtract(settlementOwnerDetail.getLossFreight());
            }
        }
        else { //订单结算方式为“卸车净重”时，开票金额=实际净重*平台运费报价。
            return settlementOwnerDetail.getWeight().multiply(settlementOwnerDetail.getFreightPrice());
        }
    }

    @Override
    public BigDecimal settlementFreightCalc(Integer settlementWay, SettlementOwnerDetail settlementOwnerDetail) {
        if (Objects.equals(settlementWay, SettlementWayEnum.WayType.LOAD.getCode())) { //订单结算方式为“装车净重”时，结算金额=实际净重*平台运费报价-预付运费-货损金额。
            return settlementOwnerDetail.getWeight().multiply(settlementOwnerDetail.getFreightPrice())
                    .subtract(settlementOwnerDetail.getPrepayFreight()).subtract(settlementOwnerDetail.getLossFreight());
        }
        else if (Objects.equals(settlementWay, SettlementWayEnum.WayType.UNLOAD_LOSS.getCode())) {
            //结算方式为“卸车净重（减货损）“，结算金额=开票金额-预付运费金额-借款抵扣金额。
            return settlementOwnerDetail.getInvoiceFreight()
                    .subtract(settlementOwnerDetail.getPrepayFreight())
                    .subtract(settlementOwnerDetail.getLoanFreight());

        }else { //订单结算方式为“卸车净重”时，结算金额=实际净重*平台运费报价-预付运费
            return settlementOwnerDetail.getWeight().multiply(settlementOwnerDetail.getFreightPrice()).subtract(settlementOwnerDetail.getPrepayFreight());
        }
    }

}
