package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractOwnerRuleDao;
import com.clx.performance.mapper.breakcontract.BreakContractOwnerRuleMapper;
import com.clx.performance.model.breakcontract.BreakContractOwnerRule;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRuleParam;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractOwnerRuleDaoImpl extends BaseDaoImpl<BreakContractOwnerRuleMapper, BreakContractOwnerRule, Integer> implements BreakContractOwnerRuleDao {

    @Override
    public boolean updateRuleStatus(BreakContractOwnerRule item) {
        return update(lUdWrapper()
                .eq(BreakContractOwnerRule::getId, item.getId())
                .set(BreakContractOwnerRule::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateFile(BreakContractOwnerRule item) {
        return update(lUdWrapper()
                .eq(BreakContractOwnerRule::getId, item.getId())
                .set(BreakContractOwnerRule::getFile, item.getFile())
        );
    }

    @Override
    public Optional<BreakContractOwnerRule> selectByName(String name) {
        return Optional.of(name)
                .map(item -> lQrWrapper()
                        .eq(BreakContractOwnerRule::getName, item)
                )
                .map(super::getOne);
    }

    @Override
    public List<BreakContractOwnerRule> listEnable() {
        return list(lQrWrapper()
                .eq(BreakContractOwnerRule::getStatus, 1)
        );
    }

    @Override
    public IPage<BreakContractOwnerRuleVO> pageByParam(PageBreakContractOwnerRuleParam param) {
        Page<BreakContractOwnerRuleVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }
}
