package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 货单定向绑定车辆表
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods_fleet_open_truck")
public class OrderGoodsFleetOpenTruck implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("truck_list_json")
    @ApiModelProperty("车辆列表")
    private String truckListJson;


    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("order_goods_no")
    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;



    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
