package com.clx.performance.controller.feign;

import com.clx.open.sdk.request.action.GetOrderBreakContractOwnerRuleFileAction;
import com.clx.open.sdk.request.dto.OrderCanExtractWeightDTO;
import com.clx.open.sdk.request.action.GetOwnerAccountInfoAction;
import com.clx.open.sdk.request.action.QueryPerformanceProgressAction;
import com.clx.open.sdk.request.action.QueryPerformanceProgressLogAction;
import com.clx.open.sdk.request.dto.OrderCanExtractWeightDTO;
import com.clx.open.sdk.request.dto.BatchOrderStatisticsInfoDTO;
import com.clx.open.sdk.request.dto.OrderStatisticsInfoDTO;
import com.clx.open.sdk.request.dto.OwnerCancelResidueWeightDTO;
import com.clx.performance.extranal.user.OrderService;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.service.OrderWeightService;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.service.PerformanceProgressService;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.clx.performance.vo.feign.OrderExtractWeightVO;
import com.clx.performance.vo.pc.OwnerAccountAllVO;
import com.clx.performance.vo.pc.PerformanceProgressOperationLogVO;
import com.clx.performance.vo.pc.PerformanceProgressVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleFileVO;
import com.msl.common.result.Result;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

import static com.clx.performance.enums.PerformanceProgressEnum.LogType.PERFORMANCE_ABNORMAL_REASON;
import javax.validation.constraints.NotBlank;

@Slf4j
@RestController
@RequestMapping("/feign/sdk")
@Validated
@Api(tags = "对外sdk Feign")
@AllArgsConstructor
public class PerformanceSdkFeignController {


    private final OrderCancelService orderCancelService;

    private final OrderGoodsService orderGoodsService;

    private final OwnerAccountService ownerAccountService;

    private final BreakContractOwnerRuleService breakContractOwnerRuleService;

    private final PerformanceProgressService performanceProgressService;

    private final OrderWeightService orderWeightService;



    private final OrderService orderService;


    @ApiOperation(value = "货主端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/ownCancelOrderPre")
    public Result<Integer> ownCancelOrderPre(@RequestBody OrderCancelParam param) {
        log.info("取消订单参数：{}", param);
        return Result.ok(orderCancelService.ownerCancelOrderPre(param));
    }

    @ApiOperation(value = "获取当前订单可取消吨数", notes = "<br>By:胡宇帆")
    @GetMapping("/orderCancelResidueWeight")
    public Result<OwnerCancelResidueWeightDTO> orderCancelResidueWeight(@RequestParam(value = "orderNo") String orderNo, @RequestParam(value = "optionType") String optionType) {
        log.info("当前订单可取消吨数参数：{}", TokenUtil.getLoginUserInfo());
        OwnerCancelResidueWeightDTO dto = new OwnerCancelResidueWeightDTO();
        dto.setWeight(orderGoodsService.orderCancelResidueWeight(orderNo, optionType).toString());
        return Result.ok(dto);
    }

    @ApiOperation(value = "获取当前用户所有账户信息", notes = "<br>By:胡宇帆")
    @GetMapping("/accountAllInfo")
    public Result<OwnerAccountAllVO> accountAllInfo(@RequestParam Long userNo) {
        return Result.ok(ownerAccountService.accountAllInfo(userNo));
    }

    @ApiOperation(value = "查询规则文档信息", notes = "<br>By:艾庆国")
    @PostMapping("/getOwnerRuleFile")
    Result<BreakContractOwnerRuleFileVO> getOwnerRuleFile(@RequestBody GetOrderBreakContractOwnerRuleFileAction action){
        return Result.ok(breakContractOwnerRuleService.getRuleFile(action.getId()));
    }

    @ApiOperation(value = "查询履约进度", notes = "<br>By:杨启发")
    @GetMapping("/queryPerformanceProgress")
    Result<List<PerformanceProgressVO>> queryPerformanceProgress(@RequestBody QueryPerformanceProgressAction action){
        return Result.ok(performanceProgressService.queryPerformanceProgress(action.getOrderNoList()));
    }

    @ApiOperation(value = "查询履约进度操作日志", notes = "<br>By:杨启发")
    @GetMapping("/queryPerformanceProgressLog")
    Result<List<PerformanceProgressOperationLogVO>> queryPerformanceProgressLog(@RequestBody QueryPerformanceProgressLogAction action){
        return Result.ok(performanceProgressService.getOperationLog(action.getOrderNo(),PERFORMANCE_ABNORMAL_REASON.getCode()));
    }
    @ApiOperation(value = "获取当前订单的可提取吨数", notes = "<br>By:刘海泉")
    @GetMapping("/getOrderCanExtractWeight")
    public Result<OrderCanExtractWeightDTO> getOrderCanExtractWeight(@RequestParam(value = "orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) {
        OrderExtractWeightVO orderCanExtractWeight = orderWeightService.getOrderCanExtractWeight(orderNo);
        OrderCanExtractWeightDTO data  = new OrderCanExtractWeightDTO();
        BeanUtils.copyProperties(orderCanExtractWeight,data);
        return Result.ok(data);
    }




    @ApiOperation(value = "查询订单相关统计信息", notes = "<br>By:刘海泉")
    @GetMapping("/queryTaskStatisticsInfo")
    Result<BatchOrderStatisticsInfoDTO> queryTaskStatisticsInfo(@RequestParam("orderNoList")
    @NotEmpty(message = "订单编号集合不能为空") List<String> orderNoList){
        return Result.ok(orderService.queryTaskStatisticsInfo(orderNoList));
    }
}
