package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.OwnerAccountEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 货主借款账户
* @Date: 2024/01/22 18:17:57
* @Version: 1.0
*/

@Schema(description = "货主借款账户")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierOwnerLoanAccountVO {

    @Schema(description = "货主编码", example = "10000000")
    private Long ownerUserNo;
    @Schema(description = "货主名称", example = "张三")
    private String ownerUserName;
    @Schema(description = "联系电话", example = "13000000000")
    private String mobile;
    @Schema(description = "默认 3：借款账户", example = "3")
    private String accountType;

    public String getAccountType(){
        return OwnerAccountEnum.AccountTypeStatus.LOAN_ACCOUNT.getMsg();
    }

    @Schema(description = "账户余额 (元) ", example = "1.23")
    private BigDecimal amount;
    public BigDecimal getAmount() {
        return BigDecimal.ZERO.add(fundingAccountBalance==null? BigDecimal.ZERO : fundingAccountBalance).add(virtuallyAccountBalance==null? BigDecimal.ZERO : virtuallyAccountBalance);
    }

    @Schema(description = "欠款金额 (元)", example = "1.23")
    private BigDecimal arrears;
    public BigDecimal getArrears() {
        return BigDecimal.ZERO.add(fundingArrears==null? BigDecimal.ZERO : fundingArrears).add(virtuallyArrears==null? BigDecimal.ZERO : virtuallyArrears);
    }

    @Schema(description = "创建人", example = "张三")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;

    @JsonIgnore
    @Schema(description = "资金账户余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingAccountBalance;
    @JsonIgnore
    @Schema(description = "资金可用余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingUsableBalance;
    @JsonIgnore
    @Schema(description = "资金冻结余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingFrozenBalance;
    @JsonIgnore
    @Schema(description = "虚拟币账户余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyAccountBalance;
    @JsonIgnore
    @Schema(description = "虚拟币可用余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyUsableBalance;
    @JsonIgnore
    @Schema(description = "虚拟币冻结余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyFrozenBalance;

    @JsonIgnore
    @Schema(description = "资金欠款", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingArrears;
    @JsonIgnore
    @Schema(description = "虚拟币欠款", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyArrears;

}