package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 油表上报信息
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@Schema(description = "油表上报信息")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckRefuelVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "用户编号", example = "")
    private Long userNo;
    @Schema(description = "用户姓名", example = "")
    private String name;
    @Schema(description = "手机号码", example = "")
    private String mobile;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
    @Schema(description = "运单编号", example = "")
    private String childNo;
    @Schema(description = "发货地址id", example = "")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "")
    private String receiveAddress;
    @Schema(description = "装车油表", example = "", hidden = true)
    private String loadImage;
    @Schema(description = "装车油表list集合", example = "")
    private List<String> loadImageList;
    public List<String> getLoadImageList() {
        return StringUtils.isEmpty(loadImage)? new ArrayList<>() : JSON.parseArray(loadImage, String.class);
    }

    @Schema(description = "装车油量", example = "")
    private BigDecimal loadOil;
    @Schema(description = "卸车油表集合", example = "", hidden = true)
    private String unloadImage;
    @Schema(description = "装车油表list集合", example = "")
    private List<String> unloadImageList;
    public List<String> getUnloadImageList() {
        return StringUtils.isEmpty(unloadImage)? new ArrayList<>() : JSON.parseArray(unloadImage, String.class);
    }

    @Schema(description = "卸车油量", example = "")
    private BigDecimal unloadOil;
    @Schema(description = "上报时间", example = "")
    private String reportTime;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}