package com.clx.performance.vo.pc.carrier.settle;

import com.clx.performance.enums.settle.SettlementDriverEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName CarrierPageSettlementOwnerDetailVO
 * @Description
 * @Author kavin
 * @Date 2023/10/16 15:01
 * @Version 1.0
 */
@Getter
@Setter
public class CarrierPageSettlementDriverVO {
    @Schema(description = "结算单Id")
    private Integer id;
    @Schema(description = "运单编号")
    private String childNo;
    @Schema(description = "货单编号")
    private String orderGoodsNo;
    @Schema(description = "订单编号")
    private String orderNo;
    @Schema(description = "车主编码")
    private Long driverUserNo;
    @Schema(description = "司机名称")
    private String driverName;
    @Schema(description = "货物id")
    private Integer goodsId;
    @Schema(description = "货物名称")
    private String goodsName;
    @Schema(description = "车牌号")
    private String truckNo;
    @Schema(description = "开票标识：1网运单 2普通单")
    private Integer invoiceType;
    @Schema(description = "结算单号")
    private String settlementNo;
    @Schema(description = "实际净重（吨）")
    private BigDecimal weight;
    @MoneyOutConvert
    @Schema(description = "运费单价")
    private BigDecimal freightPrice;
    @MoneyOutConvert
    @Schema(description = "实际运费金额")
    private BigDecimal freight;
    @Schema(description = "货损吨数（吨）")
    private BigDecimal lossWeight;
    @MoneyOutConvert
    @Schema(description = "货损单价")
    private BigDecimal lossPrice;
    @MoneyOutConvert
    @Schema(description = "货损金额")
    private BigDecimal lossFreight;
    @MoneyOutConvert
    @Schema(description = "预付运费金额")
    private BigDecimal prepayFreight;
    @Schema(description = "预付运费标示  0:未预付 1：已预付")
    private Integer prepayFreightFlag;
    @Schema(description = "借款标示  0：未借款 1：已借款 2:已还款")
    private Integer loanFlag;

    @Schema(description = "借款标示  0：未借款 1：已借款 2:已还款")
    private String loanFlagMsg;

    @Schema(description = "开票公司id")
    private Integer invoicingCompanyId;
    @Schema(description = "开票公司简称")
    private String invoicingCompanyShorterName;
    @MoneyOutConvert
    @Schema(description = "平台服务费")
    private BigDecimal platformServiceFee;
    @Schema(description = "平台服务费费率%")
    private BigDecimal platformServiceFeeRate;

    @MoneyOutConvert
    @Schema(description = "结算金额")
    private BigDecimal settlementFreight;
    @Schema(description = "状态")
    private Integer status;
    private String statusMsg;
    public String getStatusMsg() {
        return SettlementDriverEnum.Status.getMsgByCode(status);
    }
    @Schema(description = "创建时间")
    private String createTime;
    @Schema(description = "结算平台 1：马上来  2：网运平台")
    private String settlementPlatform;
    @Schema(description = "支付失败原因")
    private String payErrorMsg;







}
