package com.clx.performance.param.pc.loan.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotNull;

/**
 * @Author: aiqingguo
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class BorrowerConfigAddParam {

    @Schema(description = "借出方id", example = "1")
    @NotNull(message = "借出方id不能为空")
    private Integer borrowerId;
    @Schema(description = "类型：1虚拟货币 2 资金", example = "1")
    @NotNull(message = "类型不能为空")
    private Integer type;
    @Schema(description = "借款天数", example = "1")
    @NotNull(message = "借款天数不能为空")
    @Max(value = 365, message = "借款天数需小于等于365")
    private Integer day;

}
