package com.clx.performance.param.pc.driver;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageCarrierSettlementDriverParam extends PageParam {

    @Schema(description="货单编号",example = "201457878")
    private String orderGoodsNo;

    @Schema(description = "运单编号", example = "JS415")
    private String childNo;

    @Schema(description="车主编码",example = "201457878")
    private Long driverUserNo;

    @Schema(description="车主姓名",example = "张三")
    private String driverUserName;

    @Schema(description="状态 1:待结算  2:已结算",example = "10")
    private String status;

    @Schema(description="开始时间")
    private String startTime;

    @Schema(description="结束时间")
    private String endTime;
}
