package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildBankInfoDTO {

//    @Schema(description = "运单号", required = true)
//    private String childNo;
//    @Schema(description = "用户钱包", required = true)
//    private Integer userCode;

    @Schema(description = "持卡人姓名", required = true)
    private String name;
    @Schema(description = "银行卡卡号", required = true)
    private String cardNo;
    @Schema(description = "手机号", required = true)
    private String mobile;
    @Schema(description = "账户类型 11个人 12企业账户", required = true)
    private Integer accountType;
    @Schema(description = "银行卡类型10借记卡20借贷卡", required = true)
    private String type;

//    @Schema(description = "是否允许提现: 允许提现1 ,禁止提现0", required = true)
//    private Integer cashOut;

    @Schema(description = "身份证号", required = true)
    @NotBlank(message = "身份证号不能为空")
    private String idCard;
    @Schema(description = "银行", required = true)
    @NotBlank(message = "银行不能为空")
    private String bank;
    @Schema(description = "银行编码", required = true)
    @NotBlank(message = "银行编码不能为空")
    private String bankCode;

    @Schema(description = "身份证正面图片", required = true)
    @NotBlank(message = "身份证正面图片不能为空")
    private String idCardFrontImg;
    @Schema(description = "身份证背面图片", required = true)
    @NotBlank(message = "身份证背面图片不能为空")
    private String idCardBackImg;

}
