package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class AppCarrierDriverCollectMainParam {

    @Schema(description = "拉运意愿主键id")
    private Integer id;

    @Schema(description="问题名称")
    @Size(max = 10, message = "问题名称长度不能超过10")
    private String collectName;

    @Schema(description = "拉运意愿选项")
    private List<AppCarrierDriverCollectChildParam> recordList;
}
