package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;

/**
* @Author: aiqinguo
* @Description: 磅单审核表
* @Date: 2023/09/19 13:16:57
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class OrderChildPoundAudit implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String childNo;                         //运单编号
    private BigDecimal loadNet;                     //装货净重（单位吨）
    private BigDecimal unloadNet;                   //卸货净重（单位吨）
    private BigDecimal loadRough;                   //装货毛重（单位吨）
    private BigDecimal loadTare;                    //装货皮重（单位吨）
    private BigDecimal unloadRough;                 //卸货毛重（单位吨）
    private BigDecimal unloadTare;                  //卸货皮重（单位吨）
    private String unloadPoundNo;                   //卸货磅单编号
    private Integer status;                         //审核状态  0 待审核 1 审核通过 2 审核驳回
    private Integer rejectType;                     //审核驳回类型：1装车 2卸车 3装车+卸车
    private String remark;                          //备注
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }




    @Getter
    @AllArgsConstructor
    public enum RejectType {


        LOAD_FAIL(1, "装车"),
        UNLOAD_FAIL(2, "卸车"),
        LOAD_UNLOAD_FAIL(3, "装车+卸车"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<OrderChildPoundAudit.RejectType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}