package com.clx.performance.utils.excel;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

@Data
@NoArgsConstructor
public class ExcelData {
    private String value;
    private double doubleValue;

    private Integer styleType;
    private Integer dataType;   //数据类型：1字符串 2数字


    @Getter
    @AllArgsConstructor
    public enum DataType{
        STRING(1, "字符串"),
        NUMERIC(2, "数字"),
        ;

        private Integer value;
        private String msg;
    }

    public ExcelData(String value) {
        this(value,null);
    }
    public ExcelData(String value, String defaultValue) {
        if (!StringUtils.isBlank(value)) {
            this.value = value;
            this.dataType = DataType.STRING.value;
        }
        else {
            this.value = defaultValue;
            this.dataType = DataType.STRING.value;
        }
    }

    public ExcelData(Double value) {
        this(value,null);
    }
    public ExcelData(Double value, String defaultValue) {
        if (null != value) {
            this.doubleValue = value;
            this.dataType = DataType.NUMERIC.value;
        }
        else {
            this.value = defaultValue;
            this.dataType = DataType.STRING.value;
        }
    }
    public ExcelData(Integer value) {
        this(value,null);
    }
    public ExcelData(Integer value, String defaultValue) {
        if (null != value) {
            this.doubleValue = value;
            this.dataType = DataType.NUMERIC.value;
        }
        else {
            this.value = defaultValue;
            this.dataType = DataType.STRING.value;
        }
    }
    public ExcelData(Long value) {
        this(value,null);
    }
    public ExcelData(Long value, String defaultValue) {
        if (null != value) {
            this.doubleValue = value;
            this.dataType = DataType.NUMERIC.value;
        }
        else {
            this.value = defaultValue;
            this.dataType = DataType.STRING.value;
        }
    }
    public ExcelData(BigDecimal value) {
        this(value,null);
    }
    public ExcelData(BigDecimal value, String defaultValue) {
        if (null != value) {
            this.doubleValue = value.doubleValue();
            this.dataType = DataType.NUMERIC.value;
        }
        else {
            this.value = defaultValue;
            this.dataType = DataType.STRING.value;
        }
    }

    public double getDoubleValue() {
        return doubleValue;
    }

    public String getStringValue() {
        return value;
    }

}
