package com.clx.performance.utils.excel;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 数据导出类型 0数据 1小计 2合计 3总计
 */
@Getter
@AllArgsConstructor
public enum DataExcelTypeEnum {
    DATA_TYPE(0, "数据"),
    SUBTOTAL(1, "小计"),
    EXCELLENT(2, "合计"),
    ALL_TOTAL(3, "总计"),
    ;

    private int value;
    private String desc;


    public static String getDesc(int value) {
        for (DataExcelTypeEnum c : DataExcelTypeEnum.values()) {
            if (c.getValue() == value) {
                return c.desc;
            }
        }
        return null;
    }


}
