package com.clx.performance.struct.settle;

import com.clx.performance.model.settle.SettlementDriver;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;
import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {DateUtils.class})
public interface SettlementDriverStruct {

    @Named("toBaseVo")

    @Mapping(target = "payErrorMsg", expression = "java(com.clx.performance.service.impl.settle.SettlementDriverServiceImpl.formatPayMsg(detail.getStatus(),detail.getPayErrorMsg()))")
    @Mapping(target = "loanFlagMsg", expression = "java(com.clx.performance.enums.loan.OwnerLoanRecordEnum.LoanFlag.getMsgByCode(detail.getLoanFlag()))")
    CarrierPageSettlementDriverVO convert(SettlementDriver detail);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<CarrierPageSettlementDriverVO> covertList(List<SettlementDriver> records);
}
