package com.clx.performance.struct.loan;

import com.clx.performance.model.loan.OwnerLoanRecord;
import com.clx.performance.vo.pc.loan.carrier.CarrierCashierInfoVO;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerOrderPaymentDetailVO;
import com.clx.performance.vo.pc.loan.carrier.ExportOwnerLoanRecordVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.msl.common.utils.DateStructUtil;
import org.mapstruct.Mapper;

import java.util.List;
import java.util.Objects;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {Objects.class})

public interface OwnerLoanRecordStruct {

    List<OwnerLoanRecordVO> convertList(List<OwnerLoanRecord> list);

    CarrierCashierInfoVO convertCashierInfo(OwnerLoanRecord ownerLoanRecord);

    CarrierOwnerOrderPaymentDetailVO convertOrderPaymentDetail(OwnerLoanRecord ownerLoanRecord);

    ExportOwnerLoanRecordVO convert(OwnerLoanRecord ownerLoanRecord);
}
