package com.clx.performance.struct;

import com.clx.performance.enums.PlatformServiceFeeConfigEnum;
import com.clx.performance.model.PlatformServiceFeeConfig;
import com.clx.performance.vo.feign.PlatformServiceFeeConfigFeignVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePlatformServiceFeeConfigVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.Objects;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {PlatformServiceFeeConfigEnum.class, Objects.class, DateUtils.class})
public interface PlatformServiceFeeConfigStruct {
    @Mapping(target = "orderQuotationTypeMsg", expression = "java(Objects.isNull(config.getOrderQuotationType()) ? null : PlatformServiceFeeConfigEnum.getMsgByCode(config.getOrderQuotationType()))")
    CarrierPagePlatformServiceFeeConfigVO convertToDetail(PlatformServiceFeeConfig config);

    PlatformServiceFeeConfigFeignVO convertPlatformServiceFeeConfigFeignVO(PlatformServiceFeeConfig config);

}
