package com.clx.performance.sqlProvider.customer;

import com.clx.performance.param.pc.customer.PageCustomerComplaintDetailParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

/**
 * @ClassName CustomerComplaintDetailSqlProvider
 * @Description
 * @Author kavin
 * @Date 2023/12/13 13:31
 * @Version 1.0
 */
public class CustomerComplaintDetailSqlProvider {



    public String pageCustomerComplaintDetail(PageCustomerComplaintDetailParam param) {
        return new SQL(){{

            SELECT( " a.id, a.driver_user_no ,a.driver_name,a.driver_mobile,a.child_no," +
                    " a.complaint_type_id,a.content,a.picture,b.name," +
                    " date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(a.modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime ");
            FROM("customer_complaint_detail a");
            LEFT_OUTER_JOIN("customer_complaint_type b on a.complaint_type_id = b.id");

            if(Objects.nonNull(param.getComplaintTypeId())){
                WHERE("a.complaint_type_id = #{param.complaintTypeId}");
            }
            if(StringUtils.isNotBlank(param.getChildNo())){
                WHERE("a.child_no = #{param.childNo}");
            }

            if(StringUtils.isNotBlank(param.getDriverMobile())){
                WHERE("a.driver_mobile = #{param.driverMobile}");
            }

            if(StringUtils.isNotBlank(param.getDriverName())){
                WHERE("a.driver_name = #{param.driverName}");
            }

            if(StringUtils.isNotBlank(param.getBeginTime())){
                WHERE("a.create_time >= #{param.beginTime}");
            }
            if(StringUtils.isNotBlank(param.getEndTime())){
                WHERE("a.create_time <= #{param.endTime}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
    }
}
