package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanAccountRunningWaterRecordDao;
import com.clx.performance.dto.OwnerLoanAccountRunWaterRecordDTO;
import com.clx.performance.model.loan.OwnerLoanAccountRunningWaterRecord;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountWaterRecordOfOwnerParam;
import com.clx.performance.param.pc.loan.owner.PageOwnerLoanRunWaterRecordParam;
import com.clx.performance.service.loan.OwnerLoanAccountRunningWaterRecordService;
import com.clx.performance.struct.loan.OwnerLoanAccountRunningWaterRecordStruct;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountRunningWaterRecordVO;
import com.clx.performance.vo.pc.loan.owner.OwnerLoanRunWaterRecordVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerLoanAccountRunningWaterRecordServiceImpl  implements OwnerLoanAccountRunningWaterRecordService {


    private final OwnerLoanAccountRunningWaterRecordDao ownerLoanAccountRunningWaterRecordDao;
    private final OwnerLoanAccountRunningWaterRecordStruct ownerLoanAccountRunningWaterRecordStruct;

    @Override
    public IPage<OwnerLoanAccountRunningWaterRecordVO> pageOwnerLoanAccountWaterOfOwner(PageOwnerLoanAccountWaterRecordOfOwnerParam param) {
        return ownerLoanAccountRunningWaterRecordDao.pageByParam(param);

    }

    @Override
    public IPage<OwnerLoanRunWaterRecordVO> pageOwnerLoanRunWaterRecord(PageOwnerLoanRunWaterRecordParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        IPage<OwnerLoanAccountRunningWaterRecord> page = ownerLoanAccountRunningWaterRecordDao.pageOwnerLoanRunWaterRecord(loginUserInfo.getUserNo(),param);
        List<OwnerLoanRunWaterRecordVO> records = ownerLoanAccountRunningWaterRecordStruct.convertList(page.getRecords());
        IPage<OwnerLoanRunWaterRecordVO> returnPage = new Page<>();
        returnPage.setPages(page.getPages());
        returnPage.setTotal(page.getTotal());
        returnPage.setRecords(records);
        return returnPage;
    }

    @Override
    public List<OwnerLoanAccountRunWaterRecordDTO> exportOwnerLoanRunWaterRecord(PageOwnerLoanRunWaterRecordParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        List<OwnerLoanAccountRunningWaterRecord> list = ownerLoanAccountRunningWaterRecordDao.listOwnerLoanRunWaterRecord(loginUserInfo.getUserNo(),param);
        return ownerLoanAccountRunningWaterRecordStruct.convertDTOList(list);
    }
}
