package com.clx.performance.service.impl.linewarn;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyLineWarnConstants;
import com.clx.performance.param.mq.linewarn.*;
import com.clx.performance.service.linewarn.LineWarnMqService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class LineWarnMqServiceImpl implements LineWarnMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void orderGoodsAdd(String orderGoodsNo) {
        LineWarnOrderGoodsAddMqParam mq = new LineWarnOrderGoodsAddMqParam();
        mq.setOrderGoodsNo(orderGoodsNo);

        MqDelay delay = new MqDelay<>(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE, RabbitKeyLineWarnConstants.ORDER_GOODS_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE, RabbitKeyLineWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void lineWarn(String orderGoodsNo) {
        LineWarnLineWarnMqParam mq = new LineWarnLineWarnMqParam();
        mq.setOrderGoodsNo(orderGoodsNo);

        MqDelay delay = new MqDelay<>(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE, RabbitKeyLineWarnConstants.LINE_WARN_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE, RabbitKeyLineWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void lineWarnNotice(Integer infoId) {
        LineWarnNoticeMqParam mq = new LineWarnNoticeMqParam();
        mq.setInfoId(infoId);

        MqDelay delay = new MqDelay<>(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE, RabbitKeyLineWarnConstants.LINE_WARN_NOTICE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE, RabbitKeyLineWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void lineReport(Integer sendSystemAddressId, Integer receiveSystemAddressId,
                           Integer reportType, Integer estimatedTravelTime) {
        LineWarnLineReportMqParam mq = new LineWarnLineReportMqParam();
        mq.setSendSystemAddressId(sendSystemAddressId);
        mq.setReceiveSystemAddressId(receiveSystemAddressId);
        mq.setReportType(reportType);
        mq.setEstimatedTravelTime(estimatedTravelTime);

        MqDelay delay = new MqDelay<>(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyLineWarnConstants.LINE_WARN_LINE_REPORT_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyLineWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildWarn(String orderGoodsNo, String childNo) {
        LineWarnOrderChildWarnMqParam mq = new LineWarnOrderChildWarnMqParam();
        mq.setOrderGoodsNo(orderGoodsNo);
        mq.setChildNo(childNo);

        MqDelay delay = new MqDelay<>(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyLineWarnConstants.LINE_WARN_ORDER_CHILD_WARN_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyLineWarnConstants.DEFAULT_EXCHANGE,
                RabbitKeyLineWarnConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

}
